/*
 * Decompiled with CFR 0.152.
 */
package io.warp10.script.functions;

import com.geoxp.GeoXPLib;
import io.warp10.script.NamedWarpScriptFunction;
import io.warp10.script.WarpScriptBucketizerFunction;
import io.warp10.script.WarpScriptException;
import io.warp10.script.WarpScriptMapperFunction;
import io.warp10.script.WarpScriptReducerFunction;
import io.warp10.script.WarpScriptStack;
import io.warp10.script.WarpScriptStackFunction;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class MACROMAPPER
extends NamedWarpScriptFunction
implements WarpScriptStackFunction {
    public MACROMAPPER(String name) {
        super(name);
    }

    @Override
    public Object apply(WarpScriptStack stack) throws WarpScriptException {
        Object top = stack.pop();
        if (!(top instanceof WarpScriptStack.Macro)) {
            throw new WarpScriptException(this.getName() + " expects a macro on top of the stack.");
        }
        stack.push(new MacroMapperWrapper(this.getName(), stack, (WarpScriptStack.Macro)top));
        return stack;
    }

    public static Object[] listToObjects(List<Object> list) throws WarpScriptException {
        Object[] inarray = list.toArray();
        Object[] outarray = new Object[4];
        if (5 == inarray.length) {
            outarray[0] = ((Number)inarray[0]).longValue();
            outarray[1] = Double.isNaN(((Number)inarray[1]).doubleValue()) || Double.isNaN(((Number)inarray[2]).doubleValue()) ? Long.valueOf(91480763316633925L) : Long.valueOf(GeoXPLib.toGeoXPPoint((double)((Number)inarray[1]).doubleValue(), (double)((Number)inarray[2]).doubleValue()));
            outarray[2] = Double.isNaN(((Number)inarray[3]).doubleValue()) ? Long.valueOf(Long.MIN_VALUE) : Long.valueOf(((Number)inarray[3]).longValue());
            outarray[3] = inarray[4];
        } else if (4 == inarray.length) {
            outarray[0] = ((Number)inarray[0]).longValue();
            outarray[1] = Double.isNaN(((Number)inarray[1]).doubleValue()) || Double.isNaN(((Number)inarray[2]).doubleValue()) ? Long.valueOf(91480763316633925L) : Long.valueOf(GeoXPLib.toGeoXPPoint((double)((Number)inarray[1]).doubleValue(), (double)((Number)inarray[2]).doubleValue()));
            outarray[2] = Long.MIN_VALUE;
            outarray[3] = inarray[3];
        } else if (3 == inarray.length) {
            outarray[0] = ((Number)inarray[0]).longValue();
            outarray[1] = 91480763316633925L;
            outarray[2] = Double.isNaN(((Number)inarray[1]).doubleValue()) ? Long.valueOf(Long.MIN_VALUE) : Long.valueOf(((Number)inarray[1]).longValue());
            outarray[3] = inarray[2];
        } else if (2 == inarray.length) {
            outarray[0] = ((Number)inarray[0]).longValue();
            outarray[1] = 91480763316633925L;
            outarray[2] = Long.MIN_VALUE;
            outarray[3] = inarray[1];
        } else if (1 == inarray.length) {
            outarray[0] = 0;
            outarray[1] = 91480763316633925L;
            outarray[2] = Long.MIN_VALUE;
            outarray[3] = inarray[0];
        } else {
            throw new WarpScriptException("Expected a list of 1 to 5 elements, got " + inarray.length);
        }
        return outarray;
    }

    public static Object[] stackToObjects(WarpScriptStack stack) throws WarpScriptException {
        Object value = stack.pop();
        Object elevation = stack.pop();
        Object longitude = stack.pop();
        Object latitude = stack.pop();
        Object rtick = stack.pop();
        long location = 91480763316633925L;
        if (!(longitude instanceof Double) || !(latitude instanceof Double)) {
            throw new WarpScriptException("Macro MUST return a latitude and a longitude which are of type DOUBLE.");
        }
        if (!Double.isNaN(((Number)latitude).doubleValue()) && !Double.isNaN(((Number)longitude).doubleValue())) {
            location = GeoXPLib.toGeoXPPoint((double)((Number)latitude).doubleValue(), (double)((Number)longitude).doubleValue());
        }
        long elev = Long.MIN_VALUE;
        if (!(elevation instanceof Double) && !(elevation instanceof Long)) {
            throw new WarpScriptException("Macro MUST return an elevation which is either NaN or LONG.");
        }
        if (elevation instanceof Long) {
            elev = ((Number)elevation).longValue();
        } else if (!Double.isNaN(((Number)elevation).doubleValue())) {
            throw new WarpScriptException("Macro MUST return an elevations which is NaN if it is of type DOUBLE.");
        }
        if (!(rtick instanceof Long)) {
            throw new WarpScriptException("Macro MUST return a tick of type LONG.");
        }
        return new Object[]{(long)((Long)rtick), location, elev, value};
    }

    public static class MacroMapperWrapper
    extends NamedWarpScriptFunction
    implements WarpScriptMapperFunction,
    WarpScriptReducerFunction,
    WarpScriptBucketizerFunction {
        private final WarpScriptStack stack;
        private final WarpScriptStack.Macro macro;

        public MacroMapperWrapper(String name, WarpScriptStack stack, WarpScriptStack.Macro macro) {
            super(name);
            this.stack = stack;
            this.macro = macro;
        }

        @Override
        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append("<%");
            sb.append(" ");
            sb.append(this.macro.toString());
            sb.append(" ");
            sb.append(this.getName());
            sb.append(" ");
            sb.append("%>");
            sb.append(" ");
            sb.append("EVAL");
            return sb.toString();
        }

        @Override
        public Object apply(Object[] args) throws WarpScriptException {
            long tick = (Long)args[0];
            String[] names = (String[])args[1];
            Map[] labels = (Map[])args[2];
            long[] ticks = (long[])args[3];
            long[] locations = (long[])args[4];
            long[] elevations = (long[])args[5];
            Object[] values = (Object[])args[6];
            ArrayList<Serializable> params = new ArrayList<Serializable>(8);
            params.add(Long.valueOf(tick));
            ArrayList<String> lnames = new ArrayList<String>();
            for (String name : names) {
                lnames.add(name);
            }
            params.add(lnames);
            ArrayList<Map> llabels = new ArrayList<Map>();
            for (Map label : labels) {
                llabels.add(label);
            }
            params.add(llabels);
            ArrayList<Long> lticks = new ArrayList<Long>();
            for (long l : ticks) {
                lticks.add(l);
            }
            params.add(lticks);
            ArrayList<Double> lats = new ArrayList<Double>();
            ArrayList<Double> lons = new ArrayList<Double>();
            for (long l : locations) {
                if (91480763316633925L == l) {
                    lats.add(Double.NaN);
                    lons.add(Double.NaN);
                    continue;
                }
                double[] latlon = GeoXPLib.fromGeoXPPoint((long)l);
                lats.add(latlon[0]);
                lons.add(latlon[1]);
            }
            params.add(lats);
            params.add(lons);
            ArrayList<Number> elevs = new ArrayList<Number>();
            for (long l : elevations) {
                if (Long.MIN_VALUE == l) {
                    elevs.add(Double.NaN);
                    continue;
                }
                elevs.add(l);
            }
            params.add(elevs);
            ArrayList<Object> lvalues = new ArrayList<Object>();
            for (Object value : values) {
                lvalues.add(value);
            }
            params.add(lvalues);
            this.stack.push(params);
            this.stack.exec(this.macro);
            Object res = this.stack.peek();
            if (res instanceof List) {
                this.stack.drop();
                return MACROMAPPER.listToObjects((List)res);
            }
            if (res instanceof Map) {
                this.stack.drop();
                Set keys = ((Map)res).keySet();
                for (Object key : keys) {
                    Object[] ores2 = MACROMAPPER.listToObjects((List)((Map)res).get(key));
                    ((Map)res).put(key, ores2);
                }
                return res;
            }
            return MACROMAPPER.stackToObjects(this.stack);
        }

        public WarpScriptStack.Macro getMacro() {
            return this.macro;
        }
    }
}

