/*
 * Decompiled with CFR 0.152.
 */
package io.warp10.script.functions;

import io.warp10.continuum.store.Constants;
import io.warp10.script.NamedWarpScriptFunction;
import io.warp10.script.WarpScriptException;
import io.warp10.script.WarpScriptStack;
import io.warp10.script.WarpScriptStackFunction;

public class HUMANDURATION
extends NamedWarpScriptFunction
implements WarpScriptStackFunction {
    public HUMANDURATION(String name) {
        super(name);
    }

    @Override
    public Object apply(WarpScriptStack stack) throws WarpScriptException {
        long minutes;
        long hours;
        Object top = stack.pop();
        if (!(top instanceof Long)) {
            throw new WarpScriptException(this.getName() + " expects a number of time units (LONG) on top of the stack.");
        }
        long duration = ((Number)top).longValue();
        StringBuilder sb = new StringBuilder();
        long days = duration / (Constants.TIME_UNITS_PER_S * 86400L);
        if (duration < 0L) {
            sb.append("-");
        }
        if (Math.abs(days) > 0L) {
            sb.append(Math.abs(days));
            sb.append("d");
            duration -= days * (Constants.TIME_UNITS_PER_S * 86400L);
        }
        if (Math.abs(hours = duration / (Constants.TIME_UNITS_PER_S * 3600L)) > 0L || sb.length() > 0) {
            sb.append(Math.abs(hours));
            sb.append("h");
            duration -= hours * (Constants.TIME_UNITS_PER_S * 3600L);
        }
        if (Math.abs(minutes = duration / (Constants.TIME_UNITS_PER_S * 60L)) > 0L || sb.length() > 0) {
            sb.append(Math.abs(minutes));
            sb.append("m");
            duration -= minutes * (Constants.TIME_UNITS_PER_S * 60L);
        }
        long seconds = duration / Constants.TIME_UNITS_PER_S;
        sb.append(Math.abs(seconds));
        sb.append(".");
        sb.append(Long.toString(Constants.TIME_UNITS_PER_S + Math.abs(duration -= seconds * Constants.TIME_UNITS_PER_S)).substring(1));
        sb.append("s");
        stack.push(sb.toString());
        return stack;
    }
}

