/*
 * Decompiled with CFR 0.152.
 */
package io.warp10.script.functions;

import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.io.gml2.GMLHandler;
import io.warp10.script.functions.GeoImporter;
import java.io.IOException;
import java.io.StringReader;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class GeoKML
extends GeoImporter {
    public GeoKML(String name, boolean uniform) {
        super(name, uniform, String.class, "a KML STRING");
    }

    @Override
    protected Geometry convert(Object input) throws Exception {
        return GeoKML.KMLToGeometry((String)input);
    }

    public static Geometry KMLToGeometry(String kml) throws ParserConfigurationException, SAXException, IOException {
        SAXParserFactory fact = SAXParserFactory.newInstance();
        fact.setNamespaceAware(false);
        fact.setValidating(false);
        SAXParser parser = fact.newSAXParser();
        KMLHandler kh = new KMLHandler();
        parser.parse(new InputSource(new StringReader(kml)), (DefaultHandler)((Object)kh));
        return kh.getGeometry();
    }

    private static class KMLHandler
    extends GMLHandler {
        public KMLHandler() {
            super(new GeometryFactory(), null);
        }

        public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
            super.startElement(uri, localName, "gml:" + qName, attributes);
        }
    }
}

