/*
 * Decompiled with CFR 0.152.
 */
package io.warp10.script.functions;

import com.geoxp.GeoXPLib;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.operation.buffer.BufferOp;
import com.vividsolutions.jts.operation.buffer.BufferParameters;
import io.warp10.script.NamedWarpScriptFunction;
import io.warp10.script.WarpScriptException;
import io.warp10.script.WarpScriptStack;
import io.warp10.script.WarpScriptStackFunction;
import java.util.Map;

public class GeoImporter
extends NamedWarpScriptFunction
implements WarpScriptStackFunction {
    protected Class inputClass;
    protected String inputType;
    private final boolean uniform;

    public GeoImporter(String name, boolean uniform, Class inClass, String inType) {
        super(name);
        this.uniform = uniform;
        this.inputClass = inClass;
        this.inputType = inType;
    }

    protected Geometry convert(Object input) throws Exception {
        return null;
    }

    @Override
    public Object apply(WarpScriptStack stack) throws WarpScriptException {
        Geometry geometry;
        long res;
        Object inside = stack.pop();
        Object pcterror = stack.pop();
        Object input = stack.pop();
        if (!this.inputClass.isInstance(input) || !(inside instanceof Boolean) || !(pcterror instanceof Double) && !(pcterror instanceof Long)) {
            throw new WarpScriptException(this.getName() + " expects " + this.inputType + ", a DOUBLE error percentage or a LONG resolution (even number between 2 and 30) and a BOOLEAN.");
        }
        if (pcterror instanceof Long && (1L == (res = ((Number)pcterror).longValue()) % 2L || res > 30L || res < 2L)) {
            throw new WarpScriptException(this.getName() + " expects the resolution to be an even number between 2 and 30");
        }
        try {
            geometry = this.convert(input);
        }
        catch (Exception e) {
            throw new WarpScriptException(this.getName() + " expects valid " + this.inputType + ".", e);
        }
        Map buffer = (Map)stack.getAttribute("geo.buffer");
        if (null != buffer) {
            stack.setAttribute("geo.buffer", null);
            BufferOp bop = new BufferOp(geometry, (BufferParameters)buffer.get("params"));
            geometry = bop.getResultGeometry(((Double)buffer.get("dist")).doubleValue());
        }
        int maxcells = ((Number)stack.getAttribute("stack.maxgeocells")).intValue();
        GeoXPLib.GeoXPShape shape = !this.uniform ? (pcterror instanceof Double ? GeoXPLib.toGeoXPShape((Geometry)geometry, (double)((Number)pcterror).doubleValue(), (boolean)Boolean.TRUE.equals(inside), (int)maxcells) : GeoXPLib.toGeoXPShape((Geometry)geometry, (int)((Number)pcterror).intValue(), (boolean)Boolean.TRUE.equals(inside), (int)maxcells)) : (pcterror instanceof Double ? GeoXPLib.toUniformGeoXPShape((Geometry)geometry, (double)((Number)pcterror).doubleValue(), (boolean)Boolean.TRUE.equals(inside), (int)maxcells) : GeoXPLib.toUniformGeoXPShape((Geometry)geometry, (int)((Number)pcterror).intValue(), (boolean)Boolean.TRUE.equals(inside), (int)maxcells));
        if (null == shape) {
            throw new WarpScriptException(this.getName() + " reached the maximum number of cells in a geographic shape (warpscript.maxgeocells=" + maxcells + ").");
        }
        stack.push(shape);
        return stack;
    }
}

