/*
 * Decompiled with CFR 0.152.
 */
package io.warp10.script.functions;

import io.warp10.script.NamedWarpScriptFunction;
import io.warp10.script.WarpScriptException;
import io.warp10.script.WarpScriptStack;
import io.warp10.script.WarpScriptStackFunction;
import java.util.List;
import java.util.Map;

public class GET
extends NamedWarpScriptFunction
implements WarpScriptStackFunction {
    public GET(String name) {
        super(name);
    }

    @Override
    public Object apply(WarpScriptStack stack) throws WarpScriptException {
        Object value;
        Object key = stack.pop();
        Object coll = stack.pop();
        try {
            if (key instanceof List && coll instanceof List) {
                value = coll;
                for (Object keyElement : (List)key) {
                    value = GET.get(keyElement, value);
                }
            } else {
                value = GET.get(key, coll);
            }
        }
        catch (WarpScriptException | IndexOutOfBoundsException e) {
            throw new WarpScriptException(this.getName() + " failed.", e);
        }
        stack.push(value);
        return stack;
    }

    public static Object get(Object key, Object collection) throws WarpScriptException {
        if (collection instanceof List) {
            if (!(key instanceof Long)) {
                throw new WarpScriptException("Getting on LIST requires a LONG.");
            }
            int idx = ((Long)key).intValue();
            int size = ((List)collection).size();
            idx = GET.computeAndCheckIndex(idx, size);
            return ((List)collection).get(idx);
        }
        if (collection instanceof Map) {
            return ((Map)collection).get(key);
        }
        if (collection instanceof String) {
            if (!(key instanceof Long)) {
                throw new WarpScriptException("Getting on STRING requires a LONG.");
            }
            int idx = ((Long)key).intValue();
            int size = ((String)collection).length();
            idx = GET.computeAndCheckIndex(idx, size);
            return String.valueOf(((String)collection).charAt(idx));
        }
        if (collection instanceof byte[]) {
            if (!(key instanceof Long)) {
                throw new WarpScriptException("Getting on BYTES requires a LONG.");
            }
            int idx = ((Long)key).intValue();
            int size = ((byte[])collection).length;
            idx = GET.computeAndCheckIndex(idx, size);
            return (long)((byte[])collection)[idx] & 0xFFL;
        }
        throw new WarpScriptException("Invalid OBJECT to GET on.");
    }

    public static int computeAndCheckIndex(int index, int size) throws WarpScriptException {
        if (index < 0) {
            index += size;
        } else if (index >= size) {
            throw new WarpScriptException("Index out of bound, " + index + " >= " + size);
        }
        if (index < 0) {
            throw new WarpScriptException("Index out of bound, " + (index - size) + " < -" + size);
        }
        return index;
    }

    public static Object nestedGet(List<Object> nestedList, List<Long> indexList) throws WarpScriptException {
        Object res = nestedList;
        for (int i = 0; i < indexList.size(); ++i) {
            if (!(res instanceof List)) {
                throw new WarpScriptException("Tried to get an element at a nested path that does not exist in the input list.");
            }
            int idx = GET.computeAndCheckIndex(indexList.get(i).intValue(), res.size());
            res = res.get(idx);
        }
        return res;
    }
}

