/*
 * Decompiled with CFR 0.152.
 */
package io.warp10.script.functions;

import com.geoxp.GeoXPLib;
import com.geoxp.geo.Coverage;
import com.geoxp.geo.HHCodeHelper;
import io.warp10.script.NamedWarpScriptFunction;
import io.warp10.script.WarpScriptException;
import io.warp10.script.WarpScriptStack;
import io.warp10.script.WarpScriptStackFunction;
import java.util.ArrayList;

public class GEOSHIFT
extends NamedWarpScriptFunction
implements WarpScriptStackFunction {
    public GEOSHIFT(String name) {
        super(name);
    }

    @Override
    public Object apply(WarpScriptStack stack) throws WarpScriptException {
        Object top = stack.pop();
        if (!(top instanceof Long)) {
            throw new WarpScriptException(this.getName() + " expects a resolution, even number between 0 and 30.");
        }
        int resolution = ((Long)top).intValue();
        if (resolution < 0 || resolution > 30 || 0 != resolution % 2) {
            throw new WarpScriptException(this.getName() + " expects a resolution, even number between 0 and 30.");
        }
        resolution >>>= 1;
        top = stack.pop();
        if (!(top instanceof Number)) {
            throw new WarpScriptException(this.getName() + " expects a longitude delta between -360.0 and 360.0.");
        }
        double deltalon = ((Number)top).doubleValue();
        if (deltalon < -360.0 || deltalon > 360.0) {
            throw new WarpScriptException(this.getName() + " expects a longitude delta between -360.0 and 360.0.");
        }
        top = stack.pop();
        if (!(top instanceof Number)) {
            throw new WarpScriptException(this.getName() + " expects a latitude delta between -180.0 and 180.0.");
        }
        double deltalat = ((Number)top).doubleValue();
        if (deltalat < -180.0 || deltalat > 180.0) {
            throw new WarpScriptException(this.getName() + " expects a latitude delta between -180.0 and 180.0.");
        }
        top = stack.pop();
        double meridian = Double.NaN;
        if (top instanceof Number) {
            meridian = ((((Number)top).doubleValue() + 180.0) % 360.0 + 360.0) % 360.0;
            top = stack.pop();
        }
        if (!(top instanceof GeoXPLib.GeoXPShape)) {
            throw new WarpScriptException(this.getName() + " operates on a GEOSHAPE.");
        }
        GeoXPLib.GeoXPShape shape = (GeoXPLib.GeoXPShape)top;
        long[] cells = GeoXPLib.getCells((GeoXPLib.GeoXPShape)shape);
        int shaperes = 0;
        for (long cell : cells) {
            if (cell >>> 60 <= (long)shaperes) continue;
            shaperes = (int)(cell >>> 60);
        }
        if (0 == resolution) {
            resolution = shaperes;
        } else if (resolution > shaperes) {
            throw new WarpScriptException(this.getName() + " cannot use resolution finer than " + (shaperes << 1));
        }
        long quarterequator = 1 << (resolution << 1) >> 2 << 32 - (resolution << 1);
        long longmeridian = Double.isFinite(meridian) ? Math.round(meridian / (360.0 / (double)(1 << (resolution << 1)))) * (long)(1 << 32 - (resolution << 1)) : 0L;
        long longdeltalat = Math.round(deltalat / (180.0 / (double)(1 << (resolution << 1)))) * (long)(1 << 32 - (resolution << 1));
        long longdeltalon = Math.round(deltalon / (360.0 / (double)(1 << (resolution << 1)))) * (long)(1 << 32 - (resolution << 1));
        Coverage coverage = new Coverage();
        coverage.setAutoOptimize(true);
        long[] latlon = new long[2];
        ArrayList<Long> geocells = new ArrayList<Long>();
        for (long cell : cells) {
            int res = (int)(cell >>> 60);
            if (res >= resolution) {
                int reso = res << 1;
                long hhcode = cell << 4;
                HHCodeHelper.stableSplitHHCode((long)hhcode, (int)reso, (long[])latlon);
                long factor = !Double.isNaN(meridian) && Math.abs(latlon[1] - longmeridian) > quarterequator ? -1L : 1L;
                latlon[0] = latlon[0] + factor * longdeltalat;
                latlon[1] = latlon[1] + longdeltalon;
                hhcode = HHCodeHelper.buildHHCode((long)latlon[0], (long)latlon[1], (int)32);
                coverage.addCell(reso, hhcode);
                continue;
            }
            geocells.add(cell);
        }
        while (!geocells.isEmpty()) {
            long geocell = (Long)geocells.remove(geocells.size() - 1);
            int res = (int)(geocell >>> 60);
            int reso = res << 1;
            int reso2 = reso << 1;
            long hhcode = geocell << 4;
            if (res >= resolution) {
                HHCodeHelper.stableSplitHHCode((long)hhcode, (int)reso, (long[])latlon);
                long factor = !Double.isNaN(meridian) && Math.abs(latlon[1] - longmeridian) > quarterequator ? -1L : 1L;
                latlon[0] = latlon[0] + factor * longdeltalat;
                latlon[1] = latlon[1] + longdeltalon;
                hhcode = HHCodeHelper.buildHHCode((long)latlon[0], (long)latlon[1], (int)32);
                coverage.addCell(reso, hhcode);
                continue;
            }
            for (long offset = 0L; offset < 16L; ++offset) {
                long cell = (long)res + 1L << 60 | (hhcode | offset << 60 - reso2) >>> 4;
                geocells.add(cell);
            }
        }
        stack.push(GeoXPLib.fromCells((long[])coverage.toGeoCells(32), (boolean)false));
        return stack;
    }
}

