/*
 * Decompiled with CFR 0.152.
 */
package io.warp10.script.functions;

import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.io.ParseException;
import com.vividsolutions.jts.io.WKBWriter;
import com.vividsolutions.jts.operation.buffer.BufferOp;
import com.vividsolutions.jts.operation.buffer.BufferParameters;
import io.warp10.script.NamedWarpScriptFunction;
import io.warp10.script.WarpScriptException;
import io.warp10.script.WarpScriptStack;
import io.warp10.script.WarpScriptStackFunction;
import io.warp10.script.functions.GeoGML;
import io.warp10.script.functions.GeoJSON;
import io.warp10.script.functions.GeoKML;
import io.warp10.script.functions.GeoWKB;
import io.warp10.script.functions.GeoWKT;
import io.warp10.script.functions.TOGML;
import io.warp10.script.functions.TOKML;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import javax.xml.parsers.ParserConfigurationException;
import org.wololo.jts2geojson.GeoJSONWriter;
import org.xml.sax.SAXException;

public class GEOBUFFER
extends NamedWarpScriptFunction
implements WarpScriptStackFunction {
    public static final String ATTR_GEOBUFFER = "geo.buffer";
    private static final double DEFAULT_DISTANCE = 8.999280057595392E-6;
    public static final String KEY_DIST = "dist";
    public static final String KEY_MDIST = "mdist";
    public static final String KEY_PARAMS = "params";
    private static final String KEY_CAP = "cap";
    private static final String KEY_JOIN = "join";
    private static final String KEY_SEGMENTS = "segments";
    private static final String KEY_LIMIT = "limit";
    public static final String KEY_WKB = "wkb";
    public static final String KEY_WKT = "wkt";
    public static final String KEY_GEOJSON = "geojson";
    public static final String KEY_GML = "gml";
    public static final String KEY_KML = "kml";
    public static final String KEY_SINGLESIDED = "singlesided";
    public static final String[] ALL_INPUT_GEOMETRY_KEYS = new String[]{"wkb", "wkt", "geojson", "gml", "kml"};

    public GEOBUFFER(String name) {
        super(name);
    }

    @Override
    public Object apply(WarpScriptStack stack) throws WarpScriptException {
        WKBWriter writer;
        Object top = stack.pop();
        if (!(top instanceof Map)) {
            throw new WarpScriptException(this.getName() + " expects a buffer definition map.");
        }
        Map map = (Map)top;
        HashMap<String, Double> buffer = new HashMap<String, Double>();
        double distance = 8.999280057595392E-6;
        if (map.containsKey(KEY_DIST)) {
            distance = Double.parseDouble(String.valueOf(map.get(KEY_DIST)));
        } else if (map.containsKey(KEY_MDIST)) {
            distance = Double.parseDouble(String.valueOf(map.get(KEY_MDIST)));
            distance *= 8.999280057595392E-6;
        }
        buffer.put(KEY_DIST, distance);
        int quadrantSegments = Integer.parseInt(String.valueOf(map.getOrDefault(KEY_SEGMENTS, 8)));
        int endCapStyle = 1;
        int joinStyle = 1;
        if (map.containsKey(KEY_CAP)) {
            String cap = String.valueOf(map.get(KEY_CAP));
            if ("SQUARE".equalsIgnoreCase(cap)) {
                endCapStyle = 3;
            } else if ("FLAT".equalsIgnoreCase(cap)) {
                endCapStyle = 2;
            } else if ("ROUND".equalsIgnoreCase(cap)) {
                endCapStyle = 1;
            }
        }
        if (map.containsKey(KEY_JOIN)) {
            String join = String.valueOf(map.get(KEY_JOIN));
            if ("BEVEL".equalsIgnoreCase(join)) {
                joinStyle = 3;
            } else if ("MITRE".equalsIgnoreCase(join)) {
                joinStyle = 2;
            } else if ("ROUND".equalsIgnoreCase(join)) {
                joinStyle = 1;
            }
        }
        double mitreLimit = 5.0;
        if (map.containsKey(KEY_LIMIT)) {
            mitreLimit = Double.parseDouble(String.valueOf(map.get(KEY_LIMIT)));
        }
        BufferParameters params = new BufferParameters(quadrantSegments, endCapStyle, joinStyle, mitreLimit);
        if (map.containsKey(KEY_SINGLESIDED)) {
            params.setSingleSided(Boolean.TRUE.equals(map.get(KEY_SINGLESIDED)));
        }
        String keySet = null;
        for (String key : ALL_INPUT_GEOMETRY_KEYS) {
            if (!map.containsKey(key)) continue;
            if (null != keySet) {
                throw new WarpScriptException(this.getName() + " only one of '" + KEY_WKB + "', '" + KEY_WKT + "', '" + KEY_GEOJSON + "', '" + KEY_GML + "' or '" + KEY_KML + "' can be specified.");
            }
            keySet = key;
        }
        Object inputGeometry = map.get(keySet);
        if (KEY_WKB.equals(keySet)) {
            if (!(inputGeometry instanceof byte[])) {
                throw new WarpScriptException(this.getName() + " expects WKB to be of type BYTES.");
            }
            try {
                Geometry geometry = GeoWKB.wkbToGeometry((byte[])inputGeometry);
                BufferOp bop = new BufferOp(geometry, params);
                geometry = bop.getResultGeometry(distance);
                writer = new WKBWriter();
                stack.push(writer.write(geometry));
            }
            catch (ParseException pe) {
                throw new WarpScriptException(this.getName() + " expects valid WKB BYTES.", pe);
            }
        } else if (KEY_WKT.equals(keySet)) {
            if (!(inputGeometry instanceof String)) {
                throw new WarpScriptException(this.getName() + " expects WKT to be of type STRING.");
            }
            try {
                Geometry geometry = GeoWKT.wktToGeometry((String)inputGeometry);
                BufferOp bop = new BufferOp(geometry, params);
                geometry = bop.getResultGeometry(distance);
                stack.push(geometry.toText());
            }
            catch (ParseException pe) {
                throw new WarpScriptException(this.getName() + " expects a valid WKT STRING.", pe);
            }
        } else if (KEY_GEOJSON.equals(keySet)) {
            if (!(inputGeometry instanceof String)) {
                throw new WarpScriptException(this.getName() + " expects GeoJSON to be of type STRING.");
            }
            try {
                Geometry geometry = GeoJSON.geoJSONToGeometry((String)inputGeometry);
                BufferOp bop = new BufferOp(geometry, params);
                geometry = bop.getResultGeometry(distance);
                writer = new GeoJSONWriter();
                stack.push(writer.write(geometry).toString());
            }
            catch (UnsupportedOperationException uoe) {
                throw new WarpScriptException(this.getName() + " expects a valid GeoJSON STRING.", uoe);
            }
        } else if (KEY_GML.equals(keySet)) {
            if (!(inputGeometry instanceof String)) {
                throw new WarpScriptException(this.getName() + " expects GML to be of type STRING.");
            }
            try {
                Geometry geometry = GeoGML.GMLToGeometry((String)inputGeometry);
                BufferOp bop = new BufferOp(geometry, params);
                geometry = bop.getResultGeometry(distance);
                stack.push(TOGML.GeometryToGML(geometry));
            }
            catch (IOException | ParserConfigurationException | SAXException e) {
                throw new WarpScriptException(this.getName() + " expects a valid GML STRING.", e);
            }
        } else if (KEY_KML.equals(keySet)) {
            if (!(inputGeometry instanceof String)) {
                throw new WarpScriptException(this.getName() + " expects KML to be of type STRING.");
            }
            try {
                Geometry geometry = GeoKML.KMLToGeometry((String)inputGeometry);
                BufferOp bop = new BufferOp(geometry, params);
                geometry = bop.getResultGeometry(distance);
                stack.push(TOKML.GeometryToKML(geometry));
            }
            catch (IOException | ParserConfigurationException | SAXException e) {
                throw new WarpScriptException(this.getName() + " expects a valid KML STRING.", e);
            }
        } else {
            buffer.put(KEY_PARAMS, (Double)params);
            stack.setAttribute(ATTR_GEOBUFFER, buffer);
        }
        return stack;
    }
}

