/*
 * Decompiled with CFR 0.152.
 */
package io.warp10.script.functions;

import com.geoxp.GeoXPLib;
import io.warp10.continuum.gts.GTSHelper;
import io.warp10.continuum.gts.GeoTimeSerie;
import io.warp10.script.GTSStackFunction;
import io.warp10.script.WarpScriptException;
import io.warp10.script.WarpScriptStack;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class FILLTICKS
extends GTSStackFunction {
    private static final String LOCATION = "location";
    private static final String ELEVATION = "elevation";
    private static final String VALUE = "value";
    private static final String TICKS = "ticks";

    public FILLTICKS(String name) {
        super(name);
    }

    @Override
    protected Map<String, Object> retrieveParameters(WarpScriptStack stack) throws WarpScriptException {
        Object top = stack.pop();
        if (!(top instanceof List)) {
            throw new WarpScriptException(this.getName() + " expects a list of 5 parameters (lat, lon, elevation, value, ticks).");
        }
        List params = (List)top;
        if (5 != params.size()) {
            throw new WarpScriptException(this.getName() + " expects 5 parameters (lat, lon, elevation, value, ticks).");
        }
        double lat = (Double)params.get(0);
        double lon = (Double)params.get(1);
        long location = 91480763316633925L;
        long elevation = Long.MIN_VALUE;
        if (!((Double)params.get(0)).isNaN() && !((Double)params.get(1)).isNaN()) {
            location = GeoXPLib.toGeoXPPoint((double)lat, (double)lon);
        }
        if (!(params.get(2) instanceof Double) || !((Double)params.get(2)).isNaN()) {
            elevation = (Long)params.get(2);
        }
        Object value = params.get(3);
        Object ticks = params.get(4);
        if (!(ticks instanceof List)) {
            throw new WarpScriptException(this.getName() + " expects a list of ticks as the fifth parameter of its parameter list.");
        }
        long[] aticks = new long[((List)ticks).size()];
        int idx = 0;
        for (Object o : (List)ticks) {
            if (!(o instanceof Long)) {
                throw new WarpScriptException(this.getName() + " expects a list of ticks as the fifth parameter of its parameter list.");
            }
            aticks[idx++] = (Long)o;
        }
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put(LOCATION, location);
        parameters.put(ELEVATION, elevation);
        parameters.put(VALUE, value);
        parameters.put(TICKS, aticks);
        return parameters;
    }

    @Override
    protected Object gtsOp(Map<String, Object> params, GeoTimeSerie gts) throws WarpScriptException {
        long location = (Long)params.get(LOCATION);
        long elevation = (Long)params.get(ELEVATION);
        Object value = params.get(VALUE);
        long[] ticks = (long[])params.get(TICKS);
        GeoTimeSerie result = GTSHelper.fillticks(gts, location, elevation, value, ticks);
        return result;
    }
}

