/*
 * Decompiled with CFR 0.152.
 */
package io.warp10.script.functions;

import io.warp10.continuum.gts.UnsafeString;
import io.warp10.continuum.store.Constants;
import io.warp10.script.NamedWarpScriptFunction;
import io.warp10.script.WarpScriptException;
import io.warp10.script.WarpScriptStack;
import io.warp10.script.WarpScriptStackFunction;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.joda.time.Duration;
import org.joda.time.Instant;
import org.joda.time.MutablePeriod;
import org.joda.time.Period;
import org.joda.time.ReadWritablePeriod;
import org.joda.time.ReadableInstant;
import org.joda.time.format.ISOPeriodFormat;

public class DURATION
extends NamedWarpScriptFunction
implements WarpScriptStackFunction {
    private static final Double STU = new Double(Constants.TIME_UNITS_PER_S);
    private static final Pattern NEGATIVE_ZERO_SECONDS_PATTERN = Pattern.compile(".*-0+$");

    public DURATION(String name) {
        super(name);
    }

    @Override
    public Object apply(WarpScriptStack stack) throws WarpScriptException {
        Object o = stack.pop();
        if (!(o instanceof String)) {
            throw new WarpScriptException(this.getName() + " expects an ISO8601 duration (a string) on top of the stack. See http://en.wikipedia.org/wiki/ISO_8601#Durations");
        }
        String duration_string = o.toString();
        try {
            long duration = DURATION.parseDuration(new Instant(), duration_string, false, false);
            stack.push(duration);
        }
        catch (WarpScriptException wse) {
            throw new WarpScriptException(this.getName() + " encountered an error while parsing duration.", wse);
        }
        return stack;
    }

    public static long parseDuration(Instant ref, String duration_string, boolean allowAmbiguous, boolean toRef) throws WarpScriptException {
        long globalSignFactor = 1L;
        if (duration_string.startsWith("-")) {
            duration_string = duration_string.substring(1);
            globalSignFactor = -1L;
        }
        String[] tokens = UnsafeString.split(duration_string, '.');
        long subseconds = 0L;
        if (tokens.length > 2) {
            throw new WarpScriptException("invalid ISO8601 duration.");
        }
        if (2 == tokens.length) {
            duration_string = tokens[0].concat("S");
            String tmp = tokens[1].substring(0, tokens[1].length() - 1);
            Double d_offset = Double.valueOf("0." + tmp) * STU;
            subseconds = d_offset.longValue();
        }
        MutablePeriod period = new MutablePeriod();
        ISOPeriodFormat.standard().getParser().parseInto((ReadWritablePeriod)period, duration_string, 0, Locale.US);
        Period p = period.toPeriod();
        if (!(allowAmbiguous || p.getMonths() == 0 && p.getYears() == 0)) {
            throw new WarpScriptException("no support for ambiguous durations containing years or months, please convert those to days.");
        }
        Duration duration = toRef ? p.toDurationTo((ReadableInstant)ref) : p.toDurationFrom((ReadableInstant)ref);
        boolean negativeSubseconds = false;
        if (p.getSeconds() < 0) {
            negativeSubseconds = true;
        } else if (0 == p.getSeconds() && 0L != subseconds) {
            Matcher negativeZeroSecondMatcher = NEGATIVE_ZERO_SECONDS_PATTERN.matcher(tokens[0]);
            negativeSubseconds = negativeZeroSecondMatcher.matches();
        }
        if (negativeSubseconds) {
            subseconds = -subseconds;
        }
        return globalSignFactor * (duration.getMillis() * Constants.TIME_UNITS_PER_MS + subseconds);
    }
}

