/*
 * Decompiled with CFR 0.152.
 */
package io.warp10.script.functions;

import io.warp10.WarpConfig;
import io.warp10.WarpURLEncoder;
import io.warp10.continuum.MetadataUtils;
import io.warp10.continuum.gts.GeoTimeSerie;
import io.warp10.continuum.store.Constants;
import io.warp10.continuum.store.thrift.data.Metadata;
import io.warp10.script.NamedWarpScriptFunction;
import io.warp10.script.WarpScriptException;
import io.warp10.script.WarpScriptStack;
import io.warp10.script.WarpScriptStackFunction;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.concurrent.atomic.AtomicLong;

public class DELETE
extends NamedWarpScriptFunction
implements WarpScriptStackFunction {
    private URL url = null;

    public DELETE(String name) {
        super(name);
    }

    @Override
    public Object apply(WarpScriptStack stack) throws WarpScriptException {
        boolean onlyDryRun = false;
        long expected = Long.MAX_VALUE;
        Object o = stack.pop();
        if (o instanceof Long) {
            expected = (Long)o;
        } else if (null == o) {
            onlyDryRun = true;
        } else {
            throw new WarpScriptException(this.getName() + " expects a " + "LONG" + " count on top of the stack or " + "NULL" + " to indicate a dry run.");
        }
        o = stack.pop();
        if (!(o instanceof Long) && !(o instanceof String) && null != o) {
            throw new WarpScriptException(this.getName() + " expects the end timestamp to be a Long, a String or NULL.");
        }
        Object end = o;
        o = stack.pop();
        if (!(o instanceof Long) && !(o instanceof String) && null != o) {
            throw new WarpScriptException(this.getName() + " expects the start timestamp to be a Long, a String or NULL.");
        }
        Object start = o;
        if (null == start && null != end || null != start && null == end) {
            throw new WarpScriptException(this.getName() + " expects both start and end timestamps MUST be NULL if one of them is.");
        }
        o = stack.pop();
        if (!(o instanceof String)) {
            throw new WarpScriptException(this.getName() + " expects a Geo Time Series selector below the time parameters.");
        }
        String selector = o.toString();
        o = stack.pop();
        if (!(o instanceof String)) {
            throw new WarpScriptException(this.getName() + " expects a token below the selector.");
        }
        String token = (String)o;
        HttpURLConnection conn = null;
        try {
            if (null == this.url) {
                String url_property = WarpConfig.getProperty("warpscript.delete.endpoint");
                if (null != url_property) {
                    try {
                        this.url = new URL(url_property);
                    }
                    catch (MalformedURLException mue) {
                        throw new WarpScriptException(this.getName() + " configuration parameter '" + "warpscript.delete.endpoint" + "' does not define a valid URL.");
                    }
                } else {
                    throw new WarpScriptException(this.getName() + " configuration parameter '" + "warpscript.delete.endpoint" + "' not set.");
                }
            }
            StringBuilder qsurl = new StringBuilder(this.url.toString());
            if (null == this.url.getQuery()) {
                qsurl.append("?");
            } else {
                qsurl.append("&");
            }
            if (null != start && null != end) {
                qsurl.append("end");
                qsurl.append("=");
                qsurl.append(end);
                qsurl.append("&");
                qsurl.append("start");
                qsurl.append("=");
                qsurl.append(start);
            } else {
                qsurl.append("deleteall");
                qsurl.append("=");
                qsurl.append("true");
            }
            qsurl.append("&");
            qsurl.append("selector");
            qsurl.append("=");
            qsurl.append(WarpURLEncoder.encode(selector, StandardCharsets.UTF_8));
            if (null != stack.getAttribute("accel.nocache")) {
                boolean nocache = Boolean.TRUE.equals(stack.getAttribute("accel.nocache"));
                qsurl.append("&");
                if (nocache) {
                    qsurl.append("nocache");
                } else {
                    qsurl.append("cache");
                }
            }
            if (null != stack.getAttribute("accel.nopersist")) {
                boolean nopersist = Boolean.TRUE.equals(stack.getAttribute("accel.nopersist"));
                qsurl.append("&");
                if (nopersist) {
                    qsurl.append("nopersist");
                } else {
                    qsurl.append("persist");
                }
            }
            URL requrl = new URL(qsurl.toString() + "&" + "dryrun" + "=true");
            conn = (HttpURLConnection)requrl.openConnection();
            conn.setDoOutput(false);
            conn.setDoInput(true);
            conn.setRequestMethod("GET");
            conn.setRequestProperty(Constants.getHeader("http.header.token.DELETE"), token);
            conn.connect();
            if (200 != conn.getResponseCode()) {
                throw new WarpScriptException(this.getName() + " failed to complete dryrun request successfully (" + conn.getResponseMessage() + ")");
            }
            long actualCount = 0L;
            try (Object br = new BufferedReader(new InputStreamReader(conn.getInputStream()));){
                if (onlyDryRun) {
                    String line;
                    long gtsLimit = (Long)stack.getAttribute("gts.limit");
                    AtomicLong gtscount = (AtomicLong)stack.getAttribute("gts.count");
                    ArrayList<GeoTimeSerie> series = new ArrayList<GeoTimeSerie>();
                    while (null != (line = ((BufferedReader)br).readLine())) {
                        if (gtscount.incrementAndGet() > gtsLimit) {
                            throw new WarpScriptException(this.getName() + " exceeded limit of " + gtsLimit + " Geo Time Series, current count is " + gtscount.get());
                        }
                        Metadata meta = MetadataUtils.parseMetadata(line);
                        if (null == meta) {
                            throw new WarpScriptException(this.getName() + " got invalid Metadata from the delete endpoint: " + line);
                        }
                        GeoTimeSerie gts = new GeoTimeSerie();
                        gts.safeSetMetadata(meta);
                        series.add(gts);
                    }
                    stack.push(series);
                    WarpScriptStack warpScriptStack = stack;
                    return warpScriptStack;
                }
                while (null != ((BufferedReader)br).readLine()) {
                    if (expected >= ++actualCount) continue;
                    throw new WarpScriptException(this.getName() + " expected at most " + expected + " Geo Time Series to be deleted but " + actualCount + " would have been deleted instead.");
                }
            }
            conn.disconnect();
            conn = null;
            if (0L == actualCount) {
                stack.push(0);
                br = stack;
                return br;
            }
            requrl = new URL(qsurl.toString());
            conn = (HttpURLConnection)requrl.openConnection();
            conn.setDoOutput(false);
            conn.setDoInput(true);
            conn.setRequestMethod("GET");
            conn.setRequestProperty(Constants.getHeader("http.header.token.DELETE"), token);
            conn.connect();
            if (200 != conn.getResponseCode()) {
                throw new WarpScriptException(this.getName() + " failed to complete actual request successfully (" + conn.getResponseMessage() + ")");
            }
            br = new BufferedReader(new InputStreamReader(conn.getInputStream()));
            var16_17 = null;
            try {
                actualCount = 0L;
                while (null != ((BufferedReader)br).readLine()) {
                    ++actualCount;
                }
            }
            catch (Throwable throwable) {
                var16_17 = throwable;
                throw throwable;
            }
            finally {
                if (br != null) {
                    if (var16_17 != null) {
                        try {
                            ((BufferedReader)br).close();
                        }
                        catch (Throwable throwable) {
                            var16_17.addSuppressed(throwable);
                        }
                    } else {
                        ((BufferedReader)br).close();
                    }
                }
            }
            conn.disconnect();
            conn = null;
            stack.push(actualCount);
        }
        catch (IOException ioe) {
            throw new WarpScriptException(this.getName() + " failed.", ioe);
        }
        finally {
            if (null != conn) {
                conn.disconnect();
            }
        }
        return stack;
    }
}

