/*
 * Decompiled with CFR 0.152.
 */
package io.warp10.script.functions;

import io.warp10.continuum.gts.GTSEncoder;
import io.warp10.continuum.gts.GTSHelper;
import io.warp10.script.NamedWarpScriptFunction;
import io.warp10.script.WarpScriptException;
import io.warp10.script.WarpScriptStack;
import io.warp10.script.WarpScriptStackFunction;

public class CHUNKENCODER
extends NamedWarpScriptFunction
implements WarpScriptStackFunction {
    private final boolean withOverlap;

    public CHUNKENCODER(String name, boolean withOverlap) {
        super(name);
        this.withOverlap = withOverlap;
    }

    @Override
    public Object apply(WarpScriptStack stack) throws WarpScriptException {
        Object top = stack.pop();
        if (!(top instanceof Boolean)) {
            throw new WarpScriptException(this.getName() + " expects on top of the stack a boolean indicating whether or not to keep empty chunks.");
        }
        boolean keepempty = (Boolean)top;
        top = stack.pop();
        if (!(top instanceof String)) {
            throw new WarpScriptException(this.getName() + " expects the name of the 'chunk' label below the top of the stack.");
        }
        String chunklabel = (String)top;
        top = stack.pop();
        if (!(top instanceof Long)) {
            throw new WarpScriptException(this.getName() + " expects a number of chunks under the 'chunk' label.");
        }
        long chunkcount = (Long)top;
        long overlap = 0L;
        if (this.withOverlap) {
            top = stack.pop();
            if (!(top instanceof Long)) {
                throw new WarpScriptException(this.getName() + " expects an overlap below the number of chunks.");
            }
            overlap = (Long)top;
            if (overlap < 0L) {
                overlap = 0L;
            }
        }
        if (!((top = stack.pop()) instanceof Long)) {
            throw new WarpScriptException(this.getName() + " expects a chunk width on top of the end timestamp of the most recent chunk.");
        }
        long chunkwidth = (Long)top;
        top = stack.pop();
        if (!(top instanceof Long)) {
            throw new WarpScriptException(this.getName() + " expects the end timestamp of the most recent chunk under the chunk width.");
        }
        long lastchunk = (Long)top;
        top = stack.pop();
        if (!(top instanceof GTSEncoder)) {
            throw new WarpScriptException(this.getName() + " operates on an encoder instance.");
        }
        stack.push(GTSHelper.chunk((GTSEncoder)top, lastchunk, chunkwidth, chunkcount, chunklabel, keepempty, overlap));
        return stack;
    }
}

