/*
 * Decompiled with CFR 0.152.
 */
package io.warp10.script.functions;

import io.warp10.continuum.gts.GTSEncoder;
import io.warp10.continuum.gts.GTSHelper;
import io.warp10.continuum.gts.GeoTimeSerie;
import io.warp10.script.ElementOrListStackFunction;
import io.warp10.script.WarpScriptException;
import io.warp10.script.WarpScriptStack;

public class CHUNK
extends ElementOrListStackFunction {
    private final boolean withOverlap;

    public CHUNK(String name, boolean withOverlap) {
        super(name);
        this.withOverlap = withOverlap;
    }

    @Override
    public ElementOrListStackFunction.ElementStackFunction generateFunction(WarpScriptStack stack) throws WarpScriptException {
        long overlap;
        Object top = stack.pop();
        if (!(top instanceof Boolean)) {
            throw new WarpScriptException(this.getName() + " expects on top of the stack a boolean indicating whether or not to keep empty chunks.");
        }
        final boolean keepEmpty = (Boolean)top;
        top = stack.pop();
        if (!(top instanceof String)) {
            throw new WarpScriptException(this.getName() + " expects the name of the 'chunk' label below the top of the stack.");
        }
        final String chunkLabel = (String)top;
        top = stack.pop();
        if (!(top instanceof Long)) {
            throw new WarpScriptException(this.getName() + " expects a number of chunks under the 'chunk' label.");
        }
        final long chunkCount = (Long)top;
        if (this.withOverlap) {
            top = stack.pop();
            if (!(top instanceof Long)) {
                throw new WarpScriptException(this.getName() + " expects an overlap below the number of chunks.");
            }
            overlap = Math.max(0L, (Long)top);
        } else {
            overlap = 0L;
        }
        top = stack.pop();
        if (!(top instanceof Long)) {
            throw new WarpScriptException(this.getName() + " expects a chunk width on top of the end timestamp of the most recent chunk.");
        }
        final long chunkWidth = (Long)top;
        top = stack.pop();
        if (!(top instanceof Long)) {
            throw new WarpScriptException(this.getName() + " expects the end timestamp of the most recent chunk under the chunk width.");
        }
        final long lastChunk = (Long)top;
        return new ElementOrListStackFunction.ElementStackFunction(){

            @Override
            public Object applyOnElement(Object element) throws WarpScriptException {
                if (element instanceof GeoTimeSerie) {
                    return GTSHelper.chunk((GeoTimeSerie)element, lastChunk, chunkWidth, chunkCount, chunkLabel, keepEmpty, overlap);
                }
                if (element instanceof GTSEncoder) {
                    return GTSHelper.chunk((GTSEncoder)element, lastChunk, chunkWidth, chunkCount, chunkLabel, keepEmpty, overlap);
                }
                throw new WarpScriptException(CHUNK.this.getName() + " expects a Geo Time Series, a GTSEncoder or a list thereof under the lastchunk parameter.");
            }
        };
    }
}

