/*
 * Decompiled with CFR 0.152.
 */
package io.warp10.script.functions;

import io.warp10.script.NamedWarpScriptFunction;
import io.warp10.script.WarpScriptException;
import io.warp10.script.WarpScriptStack;
import io.warp10.script.WarpScriptStackFunction;

public abstract class BINTOx
extends NamedWarpScriptFunction
implements WarpScriptStackFunction {
    public BINTOx(String name) {
        super(name);
    }

    @Override
    public Object apply(WarpScriptStack stack) throws WarpScriptException {
        Object o = stack.pop();
        if (!(o instanceof String)) {
            throw new WarpScriptException(this.getName() + " operates on a String.");
        }
        String bin = (String)o;
        int missingBitsLength = (8 - bin.length() % 8) % 8;
        Object data = this.initData(missingBitsLength + bin.length());
        int curByte = 0;
        for (int i = 0; i < bin.length(); ++i) {
            curByte <<= 1;
            char bit = bin.charAt(i);
            if ('1' == bit) {
                curByte |= 1;
            } else if ('0' != bit) {
                throw new WarpScriptException(this.getName() + " expects a valid binary representation. \"" + bin + "\" is invalid.");
            }
            if (7 != (i + missingBitsLength) % 8) continue;
            this.updateData(data, (i + missingBitsLength) / 8, (byte)curByte);
            curByte = 0;
        }
        stack.push(this.generateResult(data));
        return stack;
    }

    public abstract Object initData(int var1);

    public abstract void updateData(Object var1, int var2, byte var3);

    public abstract Object generateResult(Object var1);
}

