/*
 * Decompiled with CFR 0.152.
 */
package io.warp10.script.functions;

import com.geoxp.GeoXPLib;
import io.warp10.continuum.gts.GTSHelper;
import io.warp10.continuum.gts.GeoTimeSerie;
import io.warp10.script.ElementOrListStackFunction;
import io.warp10.script.WarpScriptException;
import io.warp10.script.WarpScriptStack;
import io.warp10.script.functions.GET;
import java.util.ArrayList;
import java.util.List;

public class ATINDEX
extends ElementOrListStackFunction {
    public ATINDEX(String name) {
        super(name);
    }

    @Override
    public ElementOrListStackFunction.ElementStackFunction generateFunction(WarpScriptStack stack) throws WarpScriptException {
        Object o = stack.pop();
        if (!(o instanceof Number)) {
            throw new WarpScriptException(this.getName() + " expects an index on top of the stack.");
        }
        final int idx = ((Number)o).intValue();
        return new ElementOrListStackFunction.ElementStackFunction(){

            @Override
            public Object applyOnElement(Object element) throws WarpScriptException {
                if (!(element instanceof GeoTimeSerie)) {
                    throw new WarpScriptException(ATINDEX.this.getName() + " expects a Geo Time Series instance or a list thereof under the index.");
                }
                GeoTimeSerie gts = (GeoTimeSerie)element;
                return ATINDEX.getTupleAtIndex(gts, GET.computeAndCheckIndex(idx, GTSHelper.nvalues(gts)));
            }
        };
    }

    public static List<Object> getTupleAtIndex(GeoTimeSerie gts, int idx) {
        ArrayList<Object> result = new ArrayList<Object>(5);
        if (idx < 0 || idx >= GTSHelper.nvalues(gts)) {
            result.add(Double.NaN);
            result.add(Double.NaN);
            result.add(Double.NaN);
            result.add(Double.NaN);
            result.add(null);
        } else {
            Object value = GTSHelper.valueAtIndex(gts, idx);
            long elevation = GTSHelper.elevationAtIndex(gts, idx);
            long location = GTSHelper.locationAtIndex(gts, idx);
            result.add(GTSHelper.tickAtIndex(gts, idx));
            if (91480763316633925L != location) {
                double[] latlon = GeoXPLib.fromGeoXPPoint((long)location);
                result.add(latlon[0]);
                result.add(latlon[1]);
            } else {
                result.add(Double.NaN);
                result.add(Double.NaN);
            }
            if (Long.MIN_VALUE != elevation) {
                result.add(elevation);
            } else {
                result.add(Double.NaN);
            }
            result.add(value);
        }
        return result;
    }
}

