/*
 * Decompiled with CFR 0.152.
 */
package io.warp10.script.functions;

import io.warp10.script.NamedWarpScriptFunction;
import io.warp10.script.WarpScriptException;
import io.warp10.script.WarpScriptStack;
import io.warp10.script.WarpScriptStackFunction;
import io.warp10.script.functions.CSTORE;
import io.warp10.script.functions.DROP;
import io.warp10.script.functions.ENDLIST;
import io.warp10.script.functions.LOAD;
import io.warp10.script.functions.MARK;
import io.warp10.script.functions.NOOP;
import io.warp10.script.functions.NULL;
import io.warp10.script.functions.POPR;
import io.warp10.script.functions.PUSHR;
import io.warp10.script.functions.RUN;
import io.warp10.script.functions.RUNR;
import io.warp10.script.functions.STORE;
import io.warp10.script.functions.VARS;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;

public class ASREGS
extends NamedWarpScriptFunction
implements WarpScriptStackFunction {
    private static final NOOP NOOP = new NOOP("NOOP");
    private static final DROP DROP = new DROP("DROP");
    private static final HashMap<Integer, PUSHR> PUSHRX = new HashMap();
    private static final HashMap<Integer, POPR> POPRX = new HashMap();
    private static final HashMap<Integer, POPR> CPOPRX = new HashMap();
    private static final HashMap<Integer, RUNR> RUNRX = new HashMap();

    public ASREGS(String name) {
        super(name);
    }

    @Override
    public Object apply(WarpScriptStack stack) throws WarpScriptException {
        Object top = stack.pop();
        List<Object> vars = null;
        if (top instanceof List) {
            vars = (List<Object>)top;
            top = stack.pop();
        }
        if (!(top instanceof WarpScriptStack.Macro)) {
            throw new WarpScriptException(this.getName() + " expects an optional list of variable names and a macro.");
        }
        WarpScriptStack.Macro macro = (WarpScriptStack.Macro)top;
        if (null == vars) {
            try {
                vars = VARS.getVars(macro, true);
            }
            catch (WarpScriptException wse) {
                throw new WarpScriptException(this.getName() + " failed.", wse);
            }
        }
        Object[] regs = stack.getRegisters();
        int nregs = regs.length;
        BitSet inuse = new BitSet(nregs);
        ArrayList<WarpScriptStack.Macro> allmacros = new ArrayList<WarpScriptStack.Macro>();
        allmacros.add(macro);
        boolean abort = false;
        block2: while (!abort && !allmacros.isEmpty()) {
            WarpScriptStack.Macro m = (WarpScriptStack.Macro)allmacros.remove(0);
            ArrayList<Object> statements = new ArrayList<Object>(m.statements());
            block3: for (int i = 0; i < statements.size(); ++i) {
                Object previousSymbol;
                Object currentSymbol = statements.get(i);
                if (currentSymbol instanceof PUSHR) {
                    inuse.set(((PUSHR)currentSymbol).getRegister());
                    continue;
                }
                if (currentSymbol instanceof POPR) {
                    inuse.set(((POPR)currentSymbol).getRegister());
                    continue;
                }
                if (currentSymbol instanceof RUNR) {
                    inuse.set(((RUNR)currentSymbol).getRegister());
                    continue;
                }
                if (currentSymbol instanceof LOAD || currentSymbol instanceof CSTORE || currentSymbol instanceof RUN) {
                    if (0 == i) {
                        abort = true;
                        continue block2;
                    }
                    previousSymbol = statements.get(i - 1);
                    if (previousSymbol instanceof Long) {
                        inuse.set(((Long)previousSymbol).intValue());
                        continue;
                    }
                    if (previousSymbol instanceof String) continue;
                    abort = true;
                    continue;
                }
                if (currentSymbol instanceof STORE) {
                    if (0 == i) {
                        abort = true;
                        continue block2;
                    }
                    previousSymbol = statements.get(i - 1);
                    if (previousSymbol instanceof Long) {
                        inuse.set(((Long)previousSymbol).intValue());
                        continue;
                    }
                    if (previousSymbol instanceof List) {
                        for (Object elt : (List)previousSymbol) {
                            if (!(elt instanceof Long)) continue;
                            inuse.set(((Long)elt).intValue());
                        }
                        continue;
                    }
                    if (previousSymbol instanceof ENDLIST) {
                        int idx = i - 2;
                        while (idx >= 0 && !(statements.get(idx) instanceof MARK)) {
                            Object stmt;
                            if ((stmt = statements.get(idx--)) instanceof Long) {
                                inuse.set(((Long)stmt).intValue());
                                continue;
                            }
                            if (null == stmt || stmt instanceof String || stmt instanceof NULL) continue;
                            abort = true;
                            continue block3;
                        }
                        continue;
                    }
                    if (previousSymbol instanceof String) continue;
                    abort = true;
                    continue;
                }
                if (!(currentSymbol instanceof WarpScriptStack.Macro)) continue;
                allmacros.add((WarpScriptStack.Macro)currentSymbol);
            }
        }
        if (abort) {
            throw new WarpScriptException(this.getName() + " was unable to convert variables to registers.");
        }
        HashMap<String, Integer> varregs = new HashMap<String, Integer>();
        for (Object v : vars) {
            if (v instanceof Long) continue;
            if (inuse.cardinality() == nregs) break;
            if (!(v instanceof String)) {
                throw new WarpScriptException(this.getName() + " expects a list of variable names on top of the stack.");
            }
            if (null != varregs.get(v.toString())) continue;
            int regidx = inuse.nextClearBit(0);
            inuse.set(regidx);
            varregs.put(v.toString(), regidx);
        }
        allmacros.clear();
        allmacros.add((WarpScriptStack.Macro)top);
        while (!abort && !allmacros.isEmpty()) {
            WarpScriptStack.Macro m = (WarpScriptStack.Macro)allmacros.remove(0);
            ArrayList<Object> statements = new ArrayList<Object>(m.statements());
            for (int i = 0; i < statements.size(); ++i) {
                Object previousSymbol;
                Object currentSymbol = statements.get(i);
                if (currentSymbol instanceof WarpScriptStack.Macro) {
                    allmacros.add((WarpScriptStack.Macro)currentSymbol);
                    continue;
                }
                if (i > 0 && currentSymbol instanceof LOAD) {
                    previousSymbol = statements.get(i - 1);
                    if (previousSymbol instanceof String) {
                        Integer regno = (Integer)varregs.get(previousSymbol.toString());
                        if (null == regno) continue;
                        statements.set(i - 1, NOOP);
                        PUSHR pushr = PUSHRX.computeIfAbsent(regno, r -> new PUSHR("PUSHR" + r, (int)r));
                        statements.set(i, pushr);
                        continue;
                    }
                    if (previousSymbol instanceof Long) {
                        statements.set(i - 1, NOOP);
                        PUSHR pushr = PUSHRX.computeIfAbsent(((Long)previousSymbol).intValue(), r -> new PUSHR("PUSHR" + r, (int)r));
                        statements.set(i, pushr);
                        continue;
                    }
                    abort = true;
                    break;
                }
                if (i > 0 && currentSymbol instanceof RUN) {
                    previousSymbol = statements.get(i - 1);
                    if (previousSymbol instanceof String) {
                        Integer regno = (Integer)varregs.get(previousSymbol.toString());
                        if (null == regno) continue;
                        statements.set(i - 1, NOOP);
                        RUNR runr = RUNRX.computeIfAbsent(regno, r -> new RUNR("RUNR" + r, (int)r));
                        statements.set(i, runr);
                        continue;
                    }
                    if (previousSymbol instanceof Long) {
                        statements.set(i - 1, NOOP);
                        RUNR runr = RUNRX.computeIfAbsent(((Long)previousSymbol).intValue(), r -> new RUNR("RUNR" + r, (int)r));
                        statements.set(i, runr);
                        continue;
                    }
                    abort = true;
                    break;
                }
                if (i > 0 && currentSymbol instanceof STORE) {
                    previousSymbol = statements.get(i - 1);
                    if (previousSymbol instanceof String) {
                        Integer regno = (Integer)varregs.get(previousSymbol.toString());
                        if (null == regno) continue;
                        statements.set(i - 1, NOOP);
                        POPR popr = POPRX.computeIfAbsent(regno, r -> new POPR("POPR" + r, (int)r));
                        statements.set(i, popr);
                        continue;
                    }
                    if (previousSymbol instanceof List) {
                        for (int k = 0; k < ((List)previousSymbol).size(); ++k) {
                            Integer regno;
                            if (!(((List)previousSymbol).get(k) instanceof String) || null == (regno = (Integer)varregs.get(((List)previousSymbol).get(k).toString()))) continue;
                            ((List)previousSymbol).set(k, Long.valueOf(regno.intValue()));
                        }
                        continue;
                    }
                    if (previousSymbol instanceof ENDLIST) {
                        int listIndex;
                        int idx;
                        int nbOfRegOrNull = 0;
                        for (idx = i - 2; idx >= 0 && !(statements.get(idx) instanceof MARK); --idx) {
                            Object stmt = statements.get(idx);
                            if (stmt instanceof String) {
                                Integer regno = (Integer)varregs.get(stmt);
                                if (null == regno) continue;
                                statements.set(idx, regno);
                                ++nbOfRegOrNull;
                                continue;
                            }
                            if (!(stmt instanceof Long) && !(stmt instanceof NULL)) continue;
                            ++nbOfRegOrNull;
                        }
                        int listLength = i - idx - 2;
                        if (nbOfRegOrNull != listLength) continue;
                        statements.set(idx, NOOP);
                        statements.set(i - 1, NOOP);
                        statements.set(i, NOOP);
                        HashSet<Integer> regset = new HashSet<Integer>(listLength);
                        int[] regInList = new int[listLength];
                        for (listIndex = listLength - 1; listIndex >= 0; --listIndex) {
                            Object stmt = statements.get(idx + 1 + listIndex);
                            if (stmt instanceof Long) {
                                int regno = ((Long)stmt).intValue();
                                if (regset.add(regno)) {
                                    regInList[listIndex] = regno;
                                    continue;
                                }
                                regInList[listIndex] = -1;
                                continue;
                            }
                            regInList[listIndex] = -1;
                        }
                        for (listIndex = 0; listIndex < listLength; ++listIndex) {
                            int regno = regInList[listIndex];
                            if (regno < 0) {
                                statements.set(i - 2 - listIndex, DROP);
                                continue;
                            }
                            POPR popr = POPRX.computeIfAbsent(regInList[listIndex], r -> new POPR("POPR" + r, (int)r));
                            statements.set(i - 2 - listIndex, popr);
                        }
                        continue;
                    }
                    if (previousSymbol instanceof Long) {
                        statements.set(i - 1, NOOP);
                        POPR popr = POPRX.computeIfAbsent(((Long)previousSymbol).intValue(), r -> new POPR("POPR" + r, (int)r));
                        statements.set(i, popr);
                        continue;
                    }
                    abort = true;
                    break;
                }
                if (i <= 0 || !(currentSymbol instanceof CSTORE)) continue;
                previousSymbol = statements.get(i - 1);
                if (previousSymbol instanceof String) {
                    Integer regno = (Integer)varregs.get(previousSymbol.toString());
                    if (null == regno) continue;
                    statements.set(i - 1, NOOP);
                    POPR cpopr = CPOPRX.computeIfAbsent(regno, r -> new POPR("CPOPR" + r, (int)r, true));
                    statements.set(i, cpopr);
                    continue;
                }
                if (previousSymbol instanceof Long) {
                    statements.set(i - 1, NOOP);
                    POPR cpopr = CPOPRX.computeIfAbsent(((Long)previousSymbol).intValue(), r -> new POPR("CPOPR" + r, (int)r, true));
                    statements.set(i, cpopr);
                    continue;
                }
                abort = true;
                break;
            }
            if (abort) continue;
            List<Object> macstmt = m.statements();
            int noops = 0;
            for (int i = 0; i < statements.size(); ++i) {
                if (statements.get(i) instanceof NOOP) {
                    ++noops;
                    continue;
                }
                macstmt.set(i - noops, statements.get(i));
            }
            m.setSize(statements.size() - noops);
        }
        if (abort) {
            throw new WarpScriptException(this.getName() + " was unable to convert variables to registers.");
        }
        stack.push(top);
        return stack;
    }
}

