/*
 * Decompiled with CFR 0.152.
 */
package io.warp10.script.filter;

import io.warp10.continuum.gts.GeoTimeSerie;
import io.warp10.script.NamedWarpScriptFunction;
import io.warp10.script.StackUtils;
import io.warp10.script.WarpScriptException;
import io.warp10.script.WarpScriptFilterFunction;
import io.warp10.script.WarpScriptStack;
import io.warp10.script.WarpScriptStackFunction;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class FilterByLabels
extends NamedWarpScriptFunction
implements WarpScriptFilterFunction {
    private final Map<String, String> selParam;
    private final Map<String, Pattern> selectors;
    private final boolean checkLabels;
    private final boolean checkAttributes;

    public FilterByLabels(String name, Map<String, String> selectors, boolean checkLabels, boolean checkAttributes) {
        super(name);
        this.checkLabels = checkLabels;
        this.checkAttributes = checkAttributes;
        this.selParam = selectors;
        this.selectors = new HashMap<String, Pattern>();
        for (Map.Entry<String, String> entry : selectors.entrySet()) {
            String lname = entry.getKey();
            String selector = entry.getValue();
            Pattern pattern = selector.startsWith("=") ? Pattern.compile(Pattern.quote(selector.substring(1))) : (selector.startsWith("~") ? Pattern.compile(selector.substring(1)) : Pattern.compile(Pattern.quote(selector)));
            this.selectors.put(lname, pattern);
        }
    }

    @Override
    public List<GeoTimeSerie> filter(Map<String, String> commonlabels, List<GeoTimeSerie> ... series) throws WarpScriptException {
        ArrayList<GeoTimeSerie> retained = new ArrayList<GeoTimeSerie>();
        HashMap<String, Matcher> matchers = new HashMap<String, Matcher>();
        for (Map.Entry<String, Pattern> entry : this.selectors.entrySet()) {
            matchers.put(entry.getKey(), entry.getValue().matcher(""));
        }
        for (List<GeoTimeSerie> serie : series) {
            for (GeoTimeSerie gts : serie) {
                boolean matched = true;
                Map<String, String> labels = gts.getMetadata().getLabels();
                Map<String, String> attributes = gts.getMetadata().getAttributes();
                for (Map.Entry labelAndMatcher : matchers.entrySet()) {
                    String label = (String)labelAndMatcher.getKey();
                    Matcher matcher = (Matcher)labelAndMatcher.getValue();
                    boolean hasLabel = false;
                    if (this.checkLabels && labels.containsKey(label)) {
                        hasLabel = true;
                    }
                    if (!hasLabel && this.checkAttributes) {
                        if (!attributes.containsKey(label)) {
                            matched = false;
                        }
                    } else {
                        matched = hasLabel;
                    }
                    if (!matched) break;
                    if (hasLabel) {
                        if (matcher.reset(labels.get(label)).matches()) continue;
                        matched = false;
                        break;
                    }
                    if (matcher.reset(attributes.get(label)).matches()) continue;
                    matched = false;
                    break;
                }
                if (!matched) continue;
                retained.add(gts);
            }
        }
        return retained;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        sb.append(" ");
        for (Map.Entry<String, String> entry : this.selParam.entrySet()) {
            sb.append(StackUtils.toString(entry.getKey()));
            sb.append(" ");
            sb.append(StackUtils.toString(entry.getValue()));
        }
        sb.append("}");
        sb.append(" ");
        sb.append(this.getName());
        return sb.toString();
    }

    public static class Builder
    extends NamedWarpScriptFunction
    implements WarpScriptStackFunction {
        private final boolean checkLabels;
        private final boolean checkAttributes;

        public Builder(String name, boolean checkLabels, boolean checkAttribtues) {
            super(name);
            this.checkLabels = checkLabels;
            this.checkAttributes = checkAttribtues;
        }

        @Override
        public Object apply(WarpScriptStack stack) throws WarpScriptException {
            Object arg = stack.pop();
            if (!(arg instanceof Map)) {
                throw new WarpScriptException("Invalid labels/attributes selector");
            }
            stack.push(new FilterByLabels(this.getName(), (Map)arg, this.checkLabels, this.checkAttributes));
            return stack;
        }
    }
}

