/*
 * Decompiled with CFR 0.152.
 */
package io.warp10.script.ext.token;

import io.warp10.continuum.Tokens;
import io.warp10.crypto.KeyStore;
import io.warp10.crypto.OrderPreservingBase64;
import io.warp10.crypto.SipHashInline;
import io.warp10.quasar.encoder.QuasarTokenDecoder;
import io.warp10.quasar.encoder.QuasarTokenEncoder;
import io.warp10.quasar.filter.exception.QuasarTokenException;
import io.warp10.quasar.token.thrift.data.ReadToken;
import io.warp10.quasar.token.thrift.data.TokenType;
import io.warp10.quasar.token.thrift.data.WriteToken;
import io.warp10.script.NamedWarpScriptFunction;
import io.warp10.script.WarpScriptException;
import io.warp10.script.WarpScriptStack;
import io.warp10.script.WarpScriptStackFunction;
import io.warp10.script.ext.token.TokenWarpScriptExtension;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.apache.thrift.TBase;

public class TOKENDUMP
extends NamedWarpScriptFunction
implements WarpScriptStackFunction {
    private final QuasarTokenEncoder encoder = new QuasarTokenEncoder();
    public static final String KEY_PARAMS = "params";
    private final byte[] keystoreTokenAESKey;
    private final byte[] keystoreTokenSipHashKey;
    private final boolean warpKeystore;

    public TOKENDUMP(String name, KeyStore keystore, boolean warpKeystore) {
        super(name);
        if (null != keystore) {
            this.keystoreTokenAESKey = keystore.getKey("warp.aes.token");
            this.keystoreTokenSipHashKey = keystore.getKey("warp.siphash.token");
        } else {
            this.keystoreTokenAESKey = null;
            this.keystoreTokenSipHashKey = null;
        }
        this.warpKeystore = warpKeystore;
    }

    @Override
    public Object apply(WarpScriptStack stack) throws WarpScriptException {
        byte[] tokenAESKey = null;
        byte[] tokenSipHashKey = null;
        boolean customKeys = false;
        Object top = stack.pop();
        if (top instanceof byte[]) {
            customKeys = true;
            tokenSipHashKey = (byte[])top;
            top = stack.pop();
            if (!(top instanceof byte[])) {
                throw new WarpScriptException(this.getName() + " expects a BYTES AES Key if a BYTES SipHash is given.");
            }
            tokenAESKey = (byte[])top;
            top = stack.pop();
        }
        if (null == tokenAESKey) {
            if (this.warpKeystore) {
                String secret = TokenWarpScriptExtension.TOKEN_SECRET;
                if (null == secret) {
                    throw new WarpScriptException(this.getName() + " expects a token secret to be set in the configuration.");
                }
                if (!(top instanceof String)) {
                    throw new WarpScriptException(this.getName() + " expects a STRING token secret.");
                }
                if (!secret.equals(top)) {
                    throw new WarpScriptException(this.getName() + " invalid token secret.");
                }
                top = stack.pop();
            }
            if (null == this.keystoreTokenAESKey || null == this.keystoreTokenSipHashKey) {
                throw new WarpScriptException(this.getName() + " expects SipHash and AES keys to be explicitly defined.");
            }
            tokenAESKey = this.keystoreTokenAESKey;
            tokenSipHashKey = this.keystoreTokenSipHashKey;
        }
        if (!(top instanceof String)) {
            throw new WarpScriptException(this.getName() + " expects a STRING token.");
        }
        String tokenstr = (String)top;
        ReadToken rtoken = null;
        WriteToken wtoken = null;
        if (!customKeys && this.warpKeystore) {
            try {
                rtoken = Tokens.extractReadToken(tokenstr);
            }
            catch (WarpScriptException wse) {
                try {
                    wtoken = Tokens.extractWriteToken(tokenstr);
                }
                catch (Exception e) {
                    throw new WarpScriptException(this.getName() + " invalid token.", e);
                }
            }
        } else {
            byte[] token = OrderPreservingBase64.decode(tokenstr.getBytes(StandardCharsets.UTF_8));
            long[] lkey = SipHashInline.getKey(tokenSipHashKey);
            QuasarTokenDecoder dec = new QuasarTokenDecoder(lkey[0], lkey[1], tokenAESKey);
            try {
                rtoken = dec.decodeReadToken(token);
            }
            catch (QuasarTokenException qte) {
                try {
                    wtoken = dec.decodeWriteToken(token);
                }
                catch (Exception e) {
                    throw new WarpScriptException(this.getName() + " invalid token.", e);
                }
            }
        }
        String ident = this.encoder.getTokenIdent(tokenstr, tokenSipHashKey);
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("token", tokenstr);
        result.put("ident", ident);
        result.put(KEY_PARAMS, this.mapFromToken((TBase)(null != rtoken ? rtoken : wtoken)));
        stack.push(result);
        return stack;
    }

    public Map<String, Object> mapFromToken(TBase token) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        if (token instanceof ReadToken) {
            ReadToken rtoken = (ReadToken)token;
            params.put("type", TokenType.READ.toString());
            params.put("owner", Tokens.getUUID(rtoken.getBilledId()));
            params.put("application", rtoken.getAppName());
            params.put("issuance", rtoken.getIssuanceTimestamp());
            params.put("expiry", rtoken.getExpiryTimestamp());
            if (rtoken.getOwnersSize() > 0) {
                ArrayList<String> owners = new ArrayList<String>(rtoken.getOwnersSize());
                params.put("owners", owners);
                for (ByteBuffer bb : rtoken.getOwners()) {
                    owners.add(Tokens.getUUID(bb));
                }
            }
            if (rtoken.getProducersSize() > 0) {
                ArrayList<String> producers = new ArrayList<String>(rtoken.getProducersSize());
                params.put("producers", producers);
                for (ByteBuffer bb : rtoken.getProducers()) {
                    producers.add(Tokens.getUUID(bb));
                }
            }
            if (rtoken.getAppsSize() > 0) {
                ArrayList<String> applications = new ArrayList<String>(rtoken.getAppsSize());
                params.put("applications", applications);
                for (String app : rtoken.getApps()) {
                    applications.add(app);
                }
            }
            if (rtoken.getAttributesSize() > 0) {
                HashMap<String, String> attr = new HashMap<String, String>(rtoken.getAttributes());
                params.put("attributes", attr);
            }
            if (rtoken.getLabelsSize() > 0) {
                HashMap<String, String> labels = new HashMap<String, String>(rtoken.getLabels());
                params.put("labels", labels);
            }
        } else {
            WriteToken wtoken = (WriteToken)token;
            params.put("type", TokenType.WRITE.toString());
            params.put("owner", Tokens.getUUID(wtoken.getOwnerId()));
            params.put("producer", Tokens.getUUID(wtoken.getProducerId()));
            params.put("application", wtoken.getAppName());
            params.put("issuance", wtoken.getIssuanceTimestamp());
            params.put("expiry", wtoken.getExpiryTimestamp());
            if (wtoken.getAttributesSize() > 0) {
                HashMap<String, String> attr = new HashMap<String, String>(wtoken.getAttributes());
                params.put("attributes", attr);
            }
            if (wtoken.getLabelsSize() > 0) {
                HashMap<String, String> labels = new HashMap<String, String>(wtoken.getLabels());
                params.put("labels", labels);
            }
        }
        return params;
    }
}

