/*
 * Decompiled with CFR 0.152.
 */
package io.warp10.script.ext.shm;

import io.warp10.script.NamedWarpScriptFunction;
import io.warp10.script.WarpScriptException;
import io.warp10.script.WarpScriptStack;
import io.warp10.script.WarpScriptStackFunction;
import io.warp10.script.ext.shm.SharedMemoryWarpScriptExtension;
import java.util.concurrent.locks.ReentrantLock;

public class SHMSTORE
extends NamedWarpScriptFunction
implements WarpScriptStackFunction {
    public SHMSTORE(String name) {
        super(name);
    }

    @Override
    public Object apply(WarpScriptStack stack) throws WarpScriptException {
        Object mutexo = stack.getAttribute("ext.shm.mutex" + stack.getUUID());
        if (null == mutexo) {
            throw new WarpScriptException(this.getName() + " can only be called when in a MUTEX section.");
        }
        String mutex = String.valueOf(mutexo);
        Object top = stack.pop();
        if (!(top instanceof String)) {
            throw new WarpScriptException(this.getName() + " expects a symbol name.");
        }
        String symbol = (String)top;
        top = stack.pop();
        ReentrantLock lock = SharedMemoryWarpScriptExtension.getLock(mutex);
        if (!lock.isHeldByCurrentThread()) {
            throw new WarpScriptException(this.getName() + " expects the mutex '" + mutex + "' to be held when calling " + this.getName());
        }
        SharedMemoryWarpScriptExtension.store(symbol, mutex, top);
        return stack;
    }
}

