/*
 * Decompiled with CFR 0.152.
 */
package io.warp10.script.ext.shm;

import io.warp10.script.NamedWarpScriptFunction;
import io.warp10.script.WarpScriptException;
import io.warp10.script.WarpScriptStack;
import io.warp10.script.WarpScriptStackFunction;
import io.warp10.script.ext.shm.SharedMemoryWarpScriptExtension;
import java.util.concurrent.locks.ReentrantLock;

public class MUTEX
extends NamedWarpScriptFunction
implements WarpScriptStackFunction {
    static final String MUTEX_ATTRIBUTE = "ext.shm.mutex";

    public MUTEX(String name) {
        super(name);
    }

    @Override
    public Object apply(WarpScriptStack stack) throws WarpScriptException {
        if (null != stack.getAttribute(MUTEX_ATTRIBUTE + stack.getUUID())) {
            throw new WarpScriptException(this.getName() + " calls cannot be nested.");
        }
        Object top = stack.pop();
        if (!(top instanceof String)) {
            throw new WarpScriptException(this.getName() + " expects the mutex name on top of the stack.");
        }
        String mutex = String.valueOf(top);
        top = stack.pop();
        if (!(top instanceof WarpScriptStack.Macro)) {
            throw new WarpScriptException(this.getName() + " expects the macro to run below the mutex name.");
        }
        WarpScriptStack.Macro macro = (WarpScriptStack.Macro)top;
        ReentrantLock lock = SharedMemoryWarpScriptExtension.getLock(mutex);
        try {
            lock.lockInterruptibly();
            stack.setAttribute(MUTEX_ATTRIBUTE + stack.getUUID(), mutex);
            stack.exec(macro);
        }
        catch (WarpScriptException wse) {
            throw wse;
        }
        catch (Throwable t) {
            throw new WarpScriptException("Error while running mutex macro.", t);
        }
        finally {
            if (lock.isHeldByCurrentThread()) {
                lock.unlock();
                stack.setAttribute(MUTEX_ATTRIBUTE + stack.getUUID(), null);
            }
        }
        return stack;
    }
}

