/*
 * Decompiled with CFR 0.152.
 */
package io.warp10.script.ext.http;

import io.warp10.WarpConfig;
import io.warp10.script.NamedWarpScriptFunction;
import io.warp10.script.WarpScriptException;
import io.warp10.script.WarpScriptStack;
import io.warp10.script.WarpScriptStackFunction;
import io.warp10.script.WebAccessController;
import io.warp10.standalone.StandaloneWebCallService;
import io.warp10.warp.sdk.Capabilities;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.commons.codec.binary.Base64;

public class HTTP
extends NamedWarpScriptFunction
implements WarpScriptStackFunction {
    public static final String METHOD = "method";
    public static final String URL = "url";
    public static final String HEADERS = "headers";
    public static final String BODY = "body";
    public static final String CHUNK_SIZE = "chunk.size";
    public static final String CHUNK_MACRO = "chunk.macro";
    public static final String USERNAME = "username";
    public static final String PASSWORD = "password";
    public static final String STATUS_CODE = "status.code";
    public static final String STATUS_MESSAGE = "status.message";
    public static final String RESPONSE_HEADERS = "headers";
    public static final String CONTENT = "content";
    public static final String CHUNK_NUMBER = "chunk.number";
    private static final WebAccessController webAccessController;
    private static final boolean auth;
    private static final String capName;
    private static final long baseMaxRequests;
    private static final long baseMaxSize;
    private static final long baseMaxChunkSize;

    public HTTP(String name) {
        super(name);
    }

    @Override
    public Object apply(WarpScriptStack stack) throws WarpScriptException {
        AtomicLong downloadSize;
        AtomicLong urlCount;
        Object urlParam;
        Map headers;
        String method;
        Object o = stack.pop();
        if (!(o instanceof Map)) {
            throw new WarpScriptException(this.getName() + " expects a MAP as input.");
        }
        Map params = (Map)o;
        if (auth && !stack.isAuthenticated()) {
            throw new WarpScriptException(this.getName() + " requires the stack to be authenticated.");
        }
        if (null != capName && null == Capabilities.get(stack, capName)) {
            throw new WarpScriptException(this.getName() + " requires capability " + capName + ".");
        }
        long maxrequests = null != Capabilities.get(stack, "http.requests") ? Long.valueOf(Capabilities.get(stack, "http.requests")) : baseMaxRequests;
        long maxsize = null != Capabilities.get(stack, "http.size") ? Long.valueOf(Capabilities.get(stack, "http.size")) : baseMaxSize;
        Object body = params.get(BODY);
        Object oo = params.get(METHOD);
        if (null == oo) {
            method = null == body ? "GET" : "POST";
        } else if (oo instanceof String) {
            method = (String)oo;
        } else {
            throw new WarpScriptException(this.getName() + " expects " + METHOD + " to be a STRING.");
        }
        oo = params.get("headers");
        if (null == oo) {
            headers = new HashMap();
        } else if (oo instanceof Map) {
            headers = (Map)oo;
        } else {
            throw new WarpScriptException(this.getName() + " expects " + "headers" + " to be a MAP.");
        }
        Long chunkSize = null;
        oo = params.get(CHUNK_SIZE);
        if (null != oo) {
            if (!(oo instanceof Long)) {
                throw new WarpScriptException(this.getName() + " expects " + CHUNK_SIZE + " to be a LONG.");
            }
            chunkSize = (Long)oo;
            if (0L >= chunkSize) {
                throw new WarpScriptException(this.getName() + " expects " + CHUNK_SIZE + " value to be greater than 0.");
            }
            long maxChunkSize = null != Capabilities.get(stack, "http.chunksize") ? Long.valueOf(Capabilities.get(stack, "http.chunksize")) : baseMaxChunkSize;
            if (chunkSize > maxChunkSize) {
                throw new WarpScriptException(this.getName() + " expects a chunk size in number of bytes that do not exceed " + maxChunkSize + ".");
            }
        }
        WarpScriptStack.Macro chunkMacro = null;
        o = params.get(CHUNK_MACRO);
        if (null != o) {
            if (!(o instanceof WarpScriptStack.Macro)) {
                throw new WarpScriptException(this.getName() + " expects a macro in the input parameters map as value of " + CHUNK_MACRO);
            }
            chunkMacro = (WarpScriptStack.Macro)o;
        }
        if (null == (urlParam = params.get(URL))) {
            throw new WarpScriptException(this.getName() + " expects a url.");
        }
        if (!(urlParam instanceof String)) {
            throw new WarpScriptException(this.getName() + " expects " + URL + " to be a STRING.");
        }
        URL url = null;
        try {
            url = new URL((String)urlParam);
        }
        catch (MalformedURLException mue) {
            throw new WarpScriptException(this.getName() + " encountered an invalid URL.", mue);
        }
        if (!"http".equals(url.getProtocol()) && !"https".equals(url.getProtocol())) {
            throw new WarpScriptException(this.getName() + " only supports http and https protocols.");
        }
        if (!webAccessController.checkURL(url)) {
            throw new WarpScriptException(this.getName() + " invalid host or scheme in URL.");
        }
        Object ufCount = stack.getAttribute("http.requests");
        Object ufSize = stack.getAttribute("http.size");
        if (null == ufCount || null == ufSize) {
            urlCount = new AtomicLong();
            downloadSize = new AtomicLong();
            stack.setAttribute("http.requests", urlCount);
            stack.setAttribute("http.size", downloadSize);
        } else {
            urlCount = (AtomicLong)ufCount;
            downloadSize = (AtomicLong)ufSize;
        }
        if (urlCount.addAndGet(1L) > maxrequests) {
            throw new WarpScriptException(this.getName() + " is limited to " + maxrequests + " calls per script execution.");
        }
        LinkedHashMap<String, Object> res = new LinkedHashMap<String, Object>();
        HttpURLConnection conn = null;
        try {
            conn = (HttpURLConnection)url.openConnection();
            Object username = params.get(USERNAME);
            Object password = params.get(PASSWORD);
            if (null != username && null != password) {
                if (!(username instanceof String)) {
                    throw new WarpScriptException(this.getName() + " expects a STRING username when doing basic authentication.");
                }
                if (!(password instanceof String)) {
                    throw new WarpScriptException(this.getName() + " expects a STRING password when doing basic authentication.");
                }
                String userInfo = (String)username + ":" + (String)password;
                String basicAuth = "Basic " + Base64.encodeBase64String((byte[])userInfo.getBytes(StandardCharsets.UTF_8));
                conn.setRequestProperty("Authorization", basicAuth);
            }
            for (Map.Entry prop : headers.entrySet()) {
                conn.setRequestProperty(String.valueOf(prop.getKey()), String.valueOf(prop.getValue()));
            }
            conn.setDoInput(true);
            conn.setRequestMethod(method.toUpperCase());
            if (!"GET".equals(method) && !"TRACE".equals(method)) {
                byte[] bodyB = null;
                if (body instanceof String) {
                    bodyB = ((String)body).getBytes(StandardCharsets.UTF_8);
                } else if (body instanceof byte[]) {
                    bodyB = (byte[])body;
                } else if (null != body) {
                    throw new WarpScriptException(this.getName() + " expects the body of the request to be a STRING or BYTES object.");
                }
                if (null != bodyB) {
                    conn.setDoOutput(bodyB.length > 0);
                    if (bodyB.length > 0) {
                        try (OutputStream os = conn.getOutputStream();){
                            os.write(bodyB);
                        }
                    }
                }
            } else if (null != body) {
                throw new WarpScriptException(this.getName() + " " + method + " cannot be used with a body.");
            }
            res.put(STATUS_CODE, conn.getResponseCode());
            Map<String, List<String>> hdrs = conn.getHeaderFields();
            res.put("headers", hdrs);
            if (hdrs.containsKey(null)) {
                List<String> statusMsg = hdrs.get(null);
                if (statusMsg.size() > 0) {
                    res.put(STATUS_MESSAGE, statusMsg.get(0));
                } else {
                    res.put(STATUS_MESSAGE, "");
                }
            } else {
                res.put(STATUS_MESSAGE, "");
            }
            InputStream in = null;
            try {
                in = conn.getInputStream();
            }
            catch (IOException ioe) {
                in = conn.getErrorStream();
            }
            if (null == chunkSize) {
                if (null != in) {
                    int len;
                    byte[] buf = new byte[8192];
                    ByteArrayOutputStream baos = new ByteArrayOutputStream();
                    while ((len = in.read(buf)) >= 0) {
                        if (downloadSize.get() + (long)baos.size() + (long)len > maxsize) {
                            throw new WarpScriptException(this.getName() + " would exceed maximum size of content which can be retrieved via this function (" + maxsize + " bytes) per script execution.");
                        }
                        baos.write(buf, 0, len);
                    }
                    downloadSize.addAndGet(baos.size());
                    res.put(CONTENT, baos.toByteArray());
                } else {
                    res.put(CONTENT, new byte[0]);
                }
            } else {
                if (null != in) {
                    int chunkNumber = 0;
                    boolean eof = false;
                    while (!eof) {
                        int len;
                        int read;
                        ++chunkNumber;
                        byte[] buf = new byte[chunkSize.intValue()];
                        for (len = 0; len < chunkSize.intValue(); len += read) {
                            read = in.read(buf, len, chunkSize.intValue() - len);
                            if (read > 0) continue;
                            eof = true;
                            break;
                        }
                        if (len <= 0) break;
                        if (downloadSize.addAndGet(len) > maxsize) {
                            throw new WarpScriptException(this.getName() + " would exceed maximum size of content which can be retrieved via this function (" + maxsize + " bytes)");
                        }
                        if ((long)len == chunkSize) {
                            res.put(CONTENT, buf);
                        } else {
                            byte[] buf2 = new byte[len];
                            System.arraycopy(buf, 0, buf2, 0, buf2.length);
                            res.put(CONTENT, buf2);
                        }
                        res.put(CHUNK_NUMBER, new Long(chunkNumber));
                        Map chunkRes = Collections.unmodifiableMap(res);
                        stack.push(chunkRes);
                        if (null == chunkMacro) continue;
                        stack.exec(chunkMacro);
                    }
                }
                res.put(CHUNK_NUMBER, -1L);
                res.put(CONTENT, new byte[0]);
                Map chunkRes = Collections.unmodifiableMap(res);
                stack.push(chunkRes);
                if (null != chunkMacro) {
                    stack.exec(chunkMacro);
                }
                res.remove(CHUNK_NUMBER);
                res.remove(CONTENT);
            }
        }
        catch (IOException ioe) {
            throw new WarpScriptException(this.getName() + " encountered an error while making an HTTP " + method + " request to '" + url + "'", ioe);
        }
        finally {
            if (null != conn) {
                conn.disconnect();
            }
        }
        stack.push(res);
        return stack;
    }

    static {
        String patternConf = WarpConfig.getProperty("warpscript.http.host.patterns");
        webAccessController = null == patternConf ? StandaloneWebCallService.getWebAccessController() : new WebAccessController(patternConf);
        auth = "true".equals(WarpConfig.getProperty("warpscript.http.authentication.required"));
        capName = WarpConfig.getProperty("warpscript.http.capability");
        String confMaxRequests = WarpConfig.getProperty("warpscript.http.maxrequests");
        baseMaxRequests = null == confMaxRequests ? 1L : Long.parseLong(confMaxRequests);
        String confMaxSize = WarpConfig.getProperty("warpscript.http.maxsize");
        baseMaxSize = null == confMaxSize ? 65536L : Long.parseLong(confMaxSize);
        String confMaxChunkSize = WarpConfig.getProperty("warpscript.http.maxchunksize");
        baseMaxChunkSize = null == confMaxChunkSize ? 65536L : Long.parseLong(confMaxChunkSize);
    }
}

