/*
 * Decompiled with CFR 0.152.
 */
package io.warp10.script.ext.concurrent;

import io.warp10.CustomThreadFactory;
import io.warp10.script.MemoryWarpScriptStack;
import io.warp10.script.NamedWarpScriptFunction;
import io.warp10.script.WarpScriptException;
import io.warp10.script.WarpScriptStack;
import io.warp10.script.WarpScriptStackFunction;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.LockSupport;
import java.util.concurrent.locks.ReentrantLock;

public class CEVAL
extends NamedWarpScriptFunction
implements WarpScriptStackFunction {
    private static final String CONCURRENT_EXECUTION_ATTRIBUTE = "concurrent.execution";
    public static final String CONCURRENT_LOCK_ATTRIBUTE = "concurrent.lock";

    public CEVAL(String name) {
        super(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object apply(WarpScriptStack stack) throws WarpScriptException {
        if (Boolean.TRUE.equals(stack.getAttribute(CONCURRENT_EXECUTION_ATTRIBUTE))) {
            throw new WarpScriptException(this.getName() + " cannot be called from within a concurrent execution.");
        }
        Object top = stack.pop();
        if (!(top instanceof Number)) {
            throw new WarpScriptException(this.getName() + " expects a parallelism level on top of the stack.");
        }
        int parallelism = ((Number)top).intValue();
        if (parallelism < 1) {
            throw new WarpScriptException(this.getName() + " parallelism level cannot be less than 1.");
        }
        top = stack.pop();
        if (!(top instanceof List)) {
            throw new WarpScriptException(this.getName() + " expects a list of macros below the parallelism level.");
        }
        for (Object o : (List)top) {
            if (o instanceof WarpScriptStack.Macro) continue;
            throw new WarpScriptException(this.getName() + " expects a list of macros below the parallelism level.");
        }
        int nmacros = ((List)top).size();
        if (parallelism > nmacros) {
            parallelism = nmacros;
        }
        ExecutorService executor = null;
        try {
            ReentrantLock lock = new ReentrantLock();
            stack.setAttribute(CONCURRENT_EXECUTION_ATTRIBUTE, true);
            stack.setAttribute(CONCURRENT_LOCK_ATTRIBUTE, lock);
            LinkedBlockingDeque<Runnable> queue = new LinkedBlockingDeque<Runnable>(nmacros);
            executor = new ThreadPoolExecutor(parallelism, parallelism, 30L, TimeUnit.SECONDS, queue, new CustomThreadFactory("Warp CEVAL Thread"));
            stack.save();
            WarpScriptStack.StackContext context = (WarpScriptStack.StackContext)stack.pop();
            ArrayList<Future<List<Object>>> futures = new ArrayList<Future<List<Object>>>(((List)top).size());
            final AtomicBoolean aborted = new AtomicBoolean(false);
            final AtomicInteger pending = new AtomicInteger(0);
            int idx = 0;
            for (Object o : (List)top) {
                final WarpScriptStack.Macro macro = (WarpScriptStack.Macro)o;
                final MemoryWarpScriptStack newstack = ((MemoryWarpScriptStack)stack).getSubStack();
                newstack.push(context);
                newstack.restore();
                final int myidx = ++idx;
                Callable<List<Object>> task = new Callable<List<Object>>(){

                    @Override
                    public List<Object> call() throws Exception {
                        try {
                            if (aborted.get()) {
                                throw new WarpScriptException("Early abort.");
                            }
                            newstack.push(myidx);
                            newstack.exec(macro);
                            ArrayList<Object> results = new ArrayList<Object>();
                            while (newstack.depth() > 0) {
                                results.add(newstack.pop());
                            }
                            ArrayList<Object> arrayList = results;
                            return arrayList;
                        }
                        catch (Exception e) {
                            aborted.set(true);
                            if (e instanceof WarpScriptException) {
                                throw e;
                            }
                            throw new WarpScriptException(e);
                        }
                        finally {
                            pending.addAndGet(-1);
                        }
                    }
                };
                pending.addAndGet(1);
                Future<List<Object>> future = executor.submit(task);
                futures.add(future);
            }
            ArrayList results = new ArrayList();
            while (!aborted.get() && pending.get() > 0) {
                LockSupport.parkNanos(100000000L);
            }
            if (aborted.get()) {
                try {
                    executor.shutdownNow();
                    executor = null;
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
            for (Future future : futures) {
                try {
                    if (future.isDone()) {
                        results.add(future.get());
                        continue;
                    }
                    results.add(null);
                }
                catch (Exception e) {
                    if (e.getCause() instanceof WarpScriptException) {
                        throw (WarpScriptException)e.getCause();
                    }
                    throw new WarpScriptException(e.getCause());
                }
            }
            stack.push(results);
        }
        finally {
            if (null != executor) {
                executor.shutdownNow();
            }
            stack.setAttribute(CONCURRENT_EXECUTION_ATTRIBUTE, false);
            stack.setAttribute(CONCURRENT_LOCK_ATTRIBUTE, null);
        }
        return stack;
    }
}

