/*
 * Decompiled with CFR 0.152.
 */
package io.warp10.crypto;

import com.google.common.base.Preconditions;
import java.util.Properties;

public interface KeyStore {
    public static final String SIPHASH_CLASS = "warp.siphash.class";
    public static final String SIPHASH_LABELS = "warp.siphash.labels";
    public static final String SIPHASH_CLASS_SECONDARY = "warp.siphash.class.secondary";
    public static final String SIPHASH_LABELS_SECONDARY = "warp.siphash.labels.secondary";
    public static final String SIPHASH_APPID = "warp.siphash.appid";
    public static final String SIPHASH_TOKEN = "warp.siphash.token";
    public static final String AES_HBASE_METADATA = "warp.aes.hbase.metadata";
    public static final String AES_HBASE_DATA = "warp.aes.hbase.data";
    public static final String AES_TOKEN = "warp.aes.token";
    public static final String AES_RUNNER_PSK = "warp.aes.runner.psk";
    public static final String SIPHASH_KAFKA_RUNNER = "warp.siphash.kafka.runner";
    public static final String SIPHASH_KAFKA_DATA = "warp.siphash.kafka.data";
    public static final String SIPHASH_KAFKA_METADATA = "warp.siphash.kafka.metadata";
    public static final String SIPHASH_KAFKA_PLASMA_BACKEND_IN = "warp.siphash.kafka.plasma.backend.in";
    public static final String SIPHASH_KAFKA_PLASMA_BACKEND_OUT = "warp.siphash.kafka.plasma.backend.out";
    public static final String SIPHASH_KAFKA_PLASMA_FRONTEND_IN = "warp.siphash.kafka.plasma.frontend.in";
    public static final String SIPHASH_KAFKA_WEBCALL = "warp.siphash.kafka.webcall";
    public static final String SIPHASH_DIRECTORY_PSK = "warp.siphash.directory.psk";
    public static final String SIPHASH_FETCH_PSK = "warp.siphash.fetch.psk";
    public static final String AES_KAFKA_DATA = "warp.aes.kafka.data";
    public static final String AES_KAFKA_METADATA = "warp.aes.kafka.metadata";
    public static final String AES_KAFKA_PLASMA_BACKEND_IN = "warp.aes.kafka.plasma.backend.in";
    public static final String AES_KAFKA_PLASMA_BACKEND_OUT = "warp.aes.kafka.plasma.backend.out";
    public static final String AES_KAFKA_PLASMA_FRONTEND_IN = "warp.aes.kafka.plasma.frontend.in";
    public static final String AES_KAFKA_WEBCALL = "warp.aes.kafka.webcall";
    public static final String AES_LOGGING = "warp.aes.logging";
    public static final String AES_LEVELDB_METADATA = "warp.aes.leveldb.metadata";
    public static final String AES_LEVELDB_DATA = "warp.aes.leveldb.data";
    public static final String AES_SECURESCRIPTS = "warp.aes.securescripts";
    public static final String AES_METASETS = "warp.aes.metasets";
    public static final String AES_FETCHER = "warp.aes.fetcher";

    public byte[] getKey(String var1);

    public void setKey(String var1, byte[] var2);

    public byte[] decodeKey(String var1);

    public KeyStore clone();

    public void forget();

    public static byte[] checkAndSetKey(KeyStore keystore, String keystoreKey, Properties props, String configurationKey, int ... sizeInBits) {
        return KeyStore.checkAndSetKey(keystore, keystoreKey, props, configurationKey, null, sizeInBits);
    }

    public static byte[] checkAndSetKey(KeyStore keystore, String keyname, Properties props, String configurationKey, String defaultKeyValue, int ... sizeInBits) {
        String keyspec = props.getProperty(configurationKey, defaultKeyValue);
        if (null != keyspec) {
            byte[] key = keystore.decodeKey(keyspec);
            StringBuilder sizesStr = new StringBuilder();
            boolean correctSize = false;
            for (int sizeIndex = 0; sizeIndex < sizeInBits.length; ++sizeIndex) {
                if (sizeInBits[sizeIndex] == key.length * 8) {
                    correctSize = true;
                    break;
                }
                if (sizeIndex > 0) {
                    if (sizeIndex == sizeInBits.length - 1) {
                        sizesStr.append(" or ");
                    } else {
                        sizesStr.append(", ");
                    }
                }
                sizesStr.append(sizeInBits[sizeIndex]);
            }
            Preconditions.checkArgument((boolean)correctSize, (String)"Key %s MUST be %s bits long.", (Object[])new Object[]{configurationKey, sizesStr});
            keystore.setKey(keyname, key);
            return key;
        }
        return null;
    }
}

