/*
 * Decompiled with CFR 0.152.
 */
package io.warp10.continuum.gts;

import com.geoxp.GeoXPLib;
import io.warp10.continuum.gts.GTSHelper;
import io.warp10.continuum.gts.GeoTimeSerie;
import io.warp10.script.GTSStackFunction;
import io.warp10.script.WarpScriptException;
import io.warp10.script.WarpScriptStack;
import java.util.HashMap;
import java.util.Map;

public class LOCATIONOFFSET
extends GTSStackFunction {
    private static final String DIST = "dist";

    public LOCATIONOFFSET(String name) {
        super(name);
    }

    @Override
    protected Map<String, Object> retrieveParameters(WarpScriptStack stack) throws WarpScriptException {
        Object o = stack.pop();
        if (!(o instanceof Number)) {
            throw new WarpScriptException(this.getName() + " expects a distance in meters on top of the stack.");
        }
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put(DIST, ((Number)o).doubleValue());
        return params;
    }

    @Override
    protected GeoTimeSerie gtsOp(Map<String, Object> params, GeoTimeSerie gts) throws WarpScriptException {
        double dist = (Double)params.get(DIST);
        GeoTimeSerie offsetGTS = gts.cloneEmpty();
        GTSHelper.sort(gts);
        if (0 == gts.values) {
            return offsetGTS;
        }
        long lastlocation = GTSHelper.locationAtIndex(gts, 0);
        GTSHelper.setValue(offsetGTS, GTSHelper.tickAtIndex(gts, 0), lastlocation, GTSHelper.elevationAtIndex(gts, 0), GTSHelper.valueAtIndex(gts, 0), false);
        for (int i = 1; i < gts.values - 1; ++i) {
            long location = GTSHelper.locationAtIndex(gts, i);
            if (91480763316633925L == location) continue;
            if (91480763316633925L == lastlocation) {
                lastlocation = location;
                GTSHelper.setValue(offsetGTS, GTSHelper.tickAtIndex(gts, i), lastlocation, GTSHelper.elevationAtIndex(gts, i), GTSHelper.valueAtIndex(gts, i), false);
                continue;
            }
            double distance = GeoXPLib.loxodromicDistance((long)lastlocation, (long)location);
            if (!(distance >= dist)) continue;
            lastlocation = location;
            GTSHelper.setValue(offsetGTS, GTSHelper.tickAtIndex(gts, i), lastlocation, GTSHelper.elevationAtIndex(gts, i), GTSHelper.valueAtIndex(gts, i), false);
        }
        if (gts.values > 1) {
            GTSHelper.setValue(offsetGTS, GTSHelper.tickAtIndex(gts, gts.values - 1), GTSHelper.locationAtIndex(gts, gts.values - 1), GTSHelper.elevationAtIndex(gts, gts.values - 1), GTSHelper.valueAtIndex(gts, gts.values - 1), false);
        }
        return offsetGTS;
    }
}

