/*
 * Decompiled with CFR 0.152.
 */
package io.warp10.continuum.gts;

import io.warp10.continuum.gts.GTSHelper;
import io.warp10.continuum.gts.GeoTimeSerie;
import io.warp10.script.NamedWarpScriptFunction;
import io.warp10.script.WarpScriptException;
import io.warp10.script.WarpScriptStack;
import io.warp10.script.WarpScriptStackFunction;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class CORRELATE
extends NamedWarpScriptFunction {
    public CORRELATE(String name) {
        super(name);
    }

    public List<GeoTimeSerie> correlate(GeoTimeSerie gts, List<GeoTimeSerie> gts2, List<Long> offsets) throws WarpScriptException {
        if (!GTSHelper.isBucketized(gts) || gts.values != gts.bucketcount || GeoTimeSerie.TYPE.DOUBLE != gts.type && GeoTimeSerie.TYPE.LONG != gts.type) {
            throw new WarpScriptException(this.getName() + " operates on bucketized, filled numeric Geo Time Series.");
        }
        long bucketspan = gts.bucketspan;
        for (GeoTimeSerie g : gts2) {
            long bs = g.bucketspan;
            if (!GTSHelper.isBucketized(g) || g.values != g.bucketcount || GeoTimeSerie.TYPE.DOUBLE != g.type && GeoTimeSerie.TYPE.LONG != g.type) {
                throw new WarpScriptException(this.getName() + " operates on bucketized, filled numeric Geo Time Series.");
            }
            if (bs == bucketspan) continue;
            throw new WarpScriptException(this.getName() + " operates on bucketized Geo Time Series with all the same bucketspan. The expected bucketspan is " + bucketspan);
        }
        Iterator<Object> iterator = offsets.iterator();
        while (iterator.hasNext()) {
            long offset = (Long)iterator.next();
            if (offset % bucketspan == 0L) continue;
            throw new WarpScriptException(this.getName() + " expects offsets to be multiples of the bucketspan (" + bucketspan + ").");
        }
        GTSHelper.sort(gts);
        ArrayList<GeoTimeSerie> crosscorrelations = new ArrayList<GeoTimeSerie>();
        for (int i = 0; i < gts2.size(); ++i) {
            GeoTimeSerie standardized = GTSHelper.standardize(gts2.get(i));
            GTSHelper.sort(standardized);
            GeoTimeSerie crosscorrelation = new GeoTimeSerie(offsets.size());
            crosscorrelation.setMetadata(standardized.getMetadata());
            crosscorrelations.add(crosscorrelation);
            for (long offset : offsets) {
                GeoTimeSerie gtsA = gts;
                GeoTimeSerie gtsB = gts2.get(i);
                GTSHelper.sort(gtsB);
                int idxA = 0;
                int idxB = 0;
                while (idxA < gtsA.values && idxB < gtsB.values) {
                    if (gtsA.ticks[idxA] + offset < gtsB.ticks[idxB]) {
                        ++idxA;
                        continue;
                    }
                    if (gtsA.ticks[idxA] + offset <= gtsB.ticks[idxB]) break;
                    ++idxB;
                }
                if (idxA == gtsA.values || idxB == gtsB.values) {
                    GTSHelper.setValue(crosscorrelation, offset, 0.0);
                    continue;
                }
                long lastTickB = gtsB.ticks[gtsB.values - 1];
                long lastTickA = gtsA.ticks[gtsA.values - 1];
                long end = Math.min(lastTickA, lastTickB - offset);
                gtsA = GTSHelper.timeclip(gtsA, gtsA.ticks[idxA], end);
                gtsB = GTSHelper.timeclip(gtsB, gtsB.ticks[idxB], end + offset);
                gtsA = GTSHelper.standardize(gtsA);
                gtsB = GTSHelper.standardize(gtsB);
                idxA = 0;
                double sum = 0.0;
                int count = 0;
                for (idxB = 0; idxA < gtsA.values && idxB < gtsB.values; ++idxA, ++idxB) {
                    double v0 = ((Number)GTSHelper.valueAtIndex(gtsA, idxA)).doubleValue();
                    Object v1 = GTSHelper.valueAtIndex(gtsB, idxB);
                    if (null == v1) continue;
                    double v1d = ((Number)v1).doubleValue();
                    sum += v0 * v1d;
                    ++count;
                }
                if (count > 1) {
                    GTSHelper.setValue(crosscorrelation, offset, sum / (double)(count - 1));
                    continue;
                }
                if (count > 0) {
                    GTSHelper.setValue(crosscorrelation, offset, sum / (double)count);
                    continue;
                }
                GTSHelper.setValue(crosscorrelation, offset, 0.0);
            }
        }
        return crosscorrelations;
    }

    public static class Builder
    extends NamedWarpScriptFunction
    implements WarpScriptStackFunction {
        private final CORRELATE correlate;

        public Builder(String name) {
            super(name);
            this.correlate = new CORRELATE(name);
        }

        @Override
        public Object apply(WarpScriptStack stack) throws WarpScriptException {
            Object top = stack.pop();
            if (!(top instanceof List)) {
                throw new WarpScriptException(this.getName() + " expects a list of offsets on the top of the stack.");
            }
            ArrayList<Long> offsets = new ArrayList<Long>();
            for (Object o : (List)top) {
                offsets.add(((Number)o).longValue());
            }
            top = stack.pop();
            ArrayList<GeoTimeSerie> series = new ArrayList<GeoTimeSerie>();
            if (top instanceof GeoTimeSerie) {
                series.add((GeoTimeSerie)top);
            } else if (top instanceof List) {
                for (Object o : (List)top) {
                    if (!(o instanceof GeoTimeSerie)) {
                        stack.push(top);
                        throw new WarpScriptException(this.getName() + " can only operate on Geo Time Series instances.");
                    }
                    series.add((GeoTimeSerie)o);
                }
            } else {
                stack.push(top);
                throw new WarpScriptException(this.getName() + " can only operate on Geo Time Series instances.");
            }
            top = stack.pop();
            if (!(top instanceof GeoTimeSerie)) {
                throw new WarpScriptException(this.getName() + " expects a Geo Time Series two levels below the top of the stack.");
            }
            stack.push(this.correlate.correlate((GeoTimeSerie)top, series, offsets));
            return stack;
        }
    }
}

