/*
 * Decompiled with CFR 0.152.
 */
package io.warp10.continuum;

import io.warp10.ThrowableUtils;
import io.warp10.WarpConfig;
import io.warp10.WarpDist;
import io.warp10.continuum.AuthenticationPlugin;
import io.warp10.continuum.gts.GTSHelper;
import io.warp10.crypto.KeyStore;
import io.warp10.quasar.filter.QuasarTokenFilter;
import io.warp10.quasar.filter.exception.QuasarTokenException;
import io.warp10.quasar.token.thrift.data.ReadToken;
import io.warp10.quasar.token.thrift.data.TokenType;
import io.warp10.quasar.token.thrift.data.WriteToken;
import io.warp10.script.MemoryWarpScriptStack;
import io.warp10.script.WarpScriptException;
import io.warp10.script.ext.token.TOKENGEN;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.UUID;
import java.util.concurrent.locks.LockSupport;
import java.util.regex.Pattern;
import org.apache.thrift.TBase;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Tokens {
    private static final Logger LOG = LoggerFactory.getLogger(Tokens.class);
    private static final Map<String, Object> fileTokens = new HashMap<String, Object>();
    public static final Map<String, String> UUIDByIngressToken = new HashMap<String, String>();
    public static final Map<String, String> UUIDByEgressToken = new HashMap<String, String>();
    public static final Map<String, String> ApplicationByUUID = new HashMap<String, String>();
    private static KeyStore keystore;
    private static QuasarTokenFilter tokenFilter;
    private static List<AuthenticationPlugin> plugins;
    private static final List<String> blockedAttributes;
    private static final ThreadLocal<Boolean> skipCheckAttributes;

    private static QuasarTokenFilter getTokenFilter() {
        if (null != tokenFilter) {
            return tokenFilter;
        }
        keystore = WarpDist.getKeyStore();
        if (null != keystore) {
            try {
                tokenFilter = new QuasarTokenFilter(WarpConfig.getProperties(), keystore);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        return tokenFilter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static ReadToken getReadToken(String token) {
        Map<String, Object> map = fileTokens;
        synchronized (map) {
            if (fileTokens.containsKey(token) && fileTokens.get(token) instanceof ReadToken) {
                return ((ReadToken)fileTokens.get(token)).deepCopy();
            }
        }
        if (!UUIDByEgressToken.containsKey(token)) {
            return null;
        }
        ReadToken rtoken = new ReadToken();
        UUID uuid = UUID.fromString(UUIDByEgressToken.get(token));
        ByteBuffer bb = ByteBuffer.allocate(16).order(ByteOrder.BIG_ENDIAN);
        bb.putLong(uuid.getMostSignificantBits());
        bb.putLong(uuid.getLeastSignificantBits());
        bb.position(0);
        String app = ApplicationByUUID.get(UUIDByEgressToken.get(token));
        if (null != app) {
            rtoken.setAppName(app);
        } else {
            rtoken.setAppName("");
        }
        rtoken.setIssuanceTimestamp(0L);
        rtoken.setExpiryTimestamp(Long.MAX_VALUE);
        rtoken.setTokenType(TokenType.READ);
        rtoken.setBilledId(bb.duplicate());
        rtoken.addToOwners(bb.duplicate());
        rtoken.addToProducers(bb.duplicate());
        return rtoken;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static WriteToken getWriteToken(String token) {
        Map<String, Object> map = fileTokens;
        synchronized (map) {
            if (fileTokens.containsKey(token) && fileTokens.get(token) instanceof WriteToken) {
                return ((WriteToken)fileTokens.get(token)).deepCopy();
            }
        }
        if (!UUIDByIngressToken.containsKey(token)) {
            return null;
        }
        WriteToken wtoken = new WriteToken();
        UUID uuid = UUID.fromString(UUIDByIngressToken.get(token));
        ByteBuffer bb = ByteBuffer.allocate(16).order(ByteOrder.BIG_ENDIAN);
        bb.putLong(uuid.getMostSignificantBits());
        bb.putLong(uuid.getLeastSignificantBits());
        bb.position(0);
        wtoken.setProducerId(bb.duplicate());
        wtoken.setOwnerId(bb.duplicate());
        String struuid = uuid.toString();
        if (null != ApplicationByUUID.get(struuid)) {
            wtoken.setAppName(ApplicationByUUID.get(struuid));
        }
        wtoken.setIssuanceTimestamp(0L);
        wtoken.setExpiryTimestamp(Long.MAX_VALUE);
        wtoken.setTokenType(TokenType.WRITE);
        return wtoken;
    }

    public static byte[] getUUID(String uuid) {
        UUID u = UUID.fromString(uuid);
        byte[] bytes = new byte[16];
        ByteBuffer bb = ByteBuffer.wrap(bytes).order(ByteOrder.BIG_ENDIAN);
        bb.putLong(u.getMostSignificantBits());
        bb.putLong(u.getLeastSignificantBits());
        return bytes;
    }

    public static String getUUID(byte[] raw) {
        if (null == raw) {
            return null;
        }
        return Tokens.getUUID(ByteBuffer.wrap(raw).order(ByteOrder.BIG_ENDIAN));
    }

    public static String getUUID(ByteBuffer buffer) {
        ByteBuffer bb = buffer.duplicate();
        if (bb.remaining() < 16) {
            return null;
        }
        ByteOrder bo = bb.order();
        bb.order(ByteOrder.BIG_ENDIAN);
        long msb = bb.getLong();
        long lsb = bb.getLong();
        bb.order(bo);
        return new UUID(msb, lsb).toString();
    }

    public static WriteToken extractWriteToken(String token) throws WarpScriptException {
        WriteToken wtoken;
        if (!plugins.isEmpty()) {
            for (AuthenticationPlugin plugin : plugins) {
                WriteToken wtoken2 = plugin.extractWriteToken(token);
                if (null == wtoken2) continue;
                return wtoken2;
            }
        }
        if (null != (wtoken = Tokens.getWriteToken(token))) {
            Tokens.checkAttributes(wtoken);
            return wtoken;
        }
        try {
            QuasarTokenFilter qtf = Tokens.getTokenFilter();
            if (null != qtf) {
                wtoken = qtf.getWriteToken(token);
            }
        }
        catch (QuasarTokenException qte) {
            throw new WarpScriptException(qte.getMessage());
        }
        if (null == wtoken) {
            throw new WarpScriptException("Invalid token.");
        }
        Tokens.checkAttributes(wtoken);
        return wtoken;
    }

    public static ReadToken extractReadToken(String token) throws WarpScriptException {
        ReadToken rtoken;
        if (!plugins.isEmpty()) {
            for (AuthenticationPlugin plugin : plugins) {
                ReadToken rtoken2 = plugin.extractReadToken(token);
                if (null == rtoken2) continue;
                return rtoken2;
            }
        }
        if (null != (rtoken = Tokens.getReadToken(token))) {
            Tokens.checkAttributes(rtoken);
            return rtoken;
        }
        try {
            QuasarTokenFilter qtf = Tokens.getTokenFilter();
            if (null != qtf) {
                rtoken = qtf.getReadToken(token);
            }
        }
        catch (QuasarTokenException qte) {
            throw new WarpScriptException(qte.getMessage());
        }
        if (null == rtoken) {
            throw new WarpScriptException("Invalid token.");
        }
        Tokens.checkAttributes(rtoken);
        return rtoken;
    }

    private static void checkAttributes(Map<String, String> attributes) {
        if (null == blockedAttributes || blockedAttributes.isEmpty() || skipCheckAttributes.get().booleanValue() || null == attributes || attributes.isEmpty()) {
            return;
        }
        for (String attr : blockedAttributes) {
            if (!attributes.containsKey(attr)) continue;
            throw new RuntimeException("Invalid token attribute.");
        }
    }

    private static void checkAttributes(ReadToken rtoken) {
        Tokens.checkAttributes(rtoken.getAttributes());
    }

    private static void checkAttributes(WriteToken wtoken) {
        Tokens.checkAttributes(wtoken.getAttributes());
    }

    public static void disableCheckAttributes() {
        skipCheckAttributes.set(true);
    }

    public static void enableCheckAttributes() {
        skipCheckAttributes.set(false);
    }

    public static Map<String, String> labelSelectorsFromReadToken(ReadToken rtoken) {
        StringBuilder sb;
        Iterator<ByteBuffer> labels;
        LinkedHashMap<String, String> labelSelectors = new LinkedHashMap<String, String>();
        ArrayList<String> owners = new ArrayList<String>();
        ArrayList<String> producers = new ArrayList<String>();
        if (rtoken.getLabelsSize() > 0 && !(labels = rtoken.getLabels()).isEmpty()) {
            block8: for (Map.Entry<String, String> entry : labels.entrySet()) {
                switch (entry.getKey()) {
                    case ".owner": 
                    case ".app": 
                    case ".producer": {
                        continue block8;
                    }
                }
                labelSelectors.put(entry.getKey(), entry.getValue());
            }
        }
        if (rtoken.getOwnersSize() > 0) {
            for (ByteBuffer bb : rtoken.getOwners()) {
                owners.add(Tokens.getUUID(bb));
            }
        }
        if (rtoken.getProducersSize() > 0) {
            for (ByteBuffer bb : rtoken.getProducers()) {
                producers.add(Tokens.getUUID(bb));
            }
        }
        if (!producers.isEmpty()) {
            if (1 == producers.size()) {
                labelSelectors.put(".producer", "=" + (String)producers.get(0));
            } else {
                sb = new StringBuilder();
                sb.append("~^(");
                boolean first = true;
                for (String producer : producers) {
                    if (!first) {
                        sb.append("|");
                    }
                    sb.append(producer);
                    first = false;
                }
                sb.append(")$");
                labelSelectors.put(".producer", sb.toString());
            }
        }
        if (rtoken.getAppsSize() > 0) {
            if (1 == rtoken.getAppsSize()) {
                labelSelectors.put(".app", "=" + rtoken.getApps().get(0));
            } else {
                sb = new StringBuilder();
                sb.append("~^(");
                boolean first = true;
                for (String app : rtoken.getApps()) {
                    if (!first) {
                        sb.append("|");
                    }
                    sb.append(Pattern.quote(app));
                    first = false;
                }
                sb.append(")$");
                labelSelectors.put(".app", sb.toString());
            }
        }
        if (!owners.isEmpty()) {
            if (1 == owners.size()) {
                labelSelectors.put(".owner", "=" + (String)owners.get(0));
            } else {
                sb = new StringBuilder();
                sb.append("~^(");
                boolean first = true;
                for (String owner : owners) {
                    if (!first) {
                        sb.append("|");
                    }
                    sb.append(owner);
                    first = false;
                }
                sb.append(")$");
                labelSelectors.put(".owner", sb.toString());
            }
        }
        return labelSelectors;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void loadTokens(String path) {
        if (null == path) {
            return;
        }
        File f = new File(path);
        if (!f.exists()) {
            return;
        }
        HashMap<String, ReadToken> readTokens = new HashMap<String, ReadToken>();
        HashMap<String, WriteToken> writeTokens = new HashMap<String, WriteToken>();
        HashMap<String, TBase> tokens = new HashMap<String, TBase>();
        try {
            String line;
            BufferedReader br = new BufferedReader(new FileReader(path));
            while (null != (line = br.readLine())) {
                if (!(line = line.trim()).startsWith("token.")) continue;
                if (line.startsWith("token.spec")) {
                    String spec = line.replaceAll("^token.spec\\s*=\\s*", "");
                    MemoryWarpScriptStack stack = new MemoryWarpScriptStack(null, null, new Properties());
                    try {
                        stack.exec(spec);
                        Object top = stack.pop();
                        if (!(top instanceof Map)) continue;
                        Map params = (Map)top;
                        if (!params.containsKey("id")) {
                            throw new WarpScriptException("Missing 'id' field in token spec.");
                        }
                        TBase token = TOKENGEN.tokenFromMap(params, "Token generation in token file", 0x7FFFFFFFFFFFFFFL);
                        tokens.put(params.get("id").toString(), token);
                    }
                    catch (WarpScriptException wse) {
                        LOG.error("Error parsing token spec in file " + path + " at line '" + line + "': " + ThrowableUtils.getErrorMessage(wse));
                    }
                    continue;
                }
                String id = line.substring(6).replaceAll("^(read|write)\\.", "").replaceAll("\\..*", "");
                String key = line.substring(6).replaceAll("^(read|write)\\.[^.]*\\.", "");
                String type = line.substring(6).replaceAll("\\..*", "");
                String value = key.replaceAll("^[^=]*=", "").trim();
                key = key.replaceAll("\\s*=.*", "");
                ReadToken readToken = null;
                WriteToken writeToken = null;
                if ("read".equals(type)) {
                    readToken = (ReadToken)readTokens.get(id);
                    if (null == readToken) {
                        readToken = new ReadToken();
                        readToken.setIssuanceTimestamp(0L);
                        readTokens.put(id, readToken);
                    }
                    if ("producer".equals(key)) {
                        readToken.addToProducers(ByteBuffer.wrap(Tokens.getUUID(value)));
                        continue;
                    }
                    if ("owner".equals(key)) {
                        readToken.addToOwners(ByteBuffer.wrap(Tokens.getUUID(value)));
                        continue;
                    }
                    if ("app".equals(key)) {
                        readToken.addToApps(value);
                        continue;
                    }
                    if ("expiry".equals(key)) {
                        readToken.setExpiryTimestamp(Long.valueOf(value));
                        continue;
                    }
                    if ("billed".equals(key)) {
                        readToken.setBilledId(Tokens.getUUID(value));
                        continue;
                    }
                    if (!"name".equals(key) && !"id".equals(key)) continue;
                    tokens.put(value, readToken);
                    continue;
                }
                if (!"write".equals(type)) continue;
                writeToken = (WriteToken)writeTokens.get(id);
                if (null == writeToken) {
                    writeToken = new WriteToken();
                    writeToken.setIssuanceTimestamp(0L);
                    writeTokens.put(id, writeToken);
                }
                if ("producer".equals(key)) {
                    writeToken.setProducerId(Tokens.getUUID(value));
                    continue;
                }
                if ("owner".equals(key)) {
                    writeToken.setOwnerId(Tokens.getUUID(value));
                    continue;
                }
                if ("app".equals(key)) {
                    writeToken.setAppName(value);
                    continue;
                }
                if ("expiry".equals(key)) {
                    writeToken.setExpiryTimestamp(Long.valueOf(value));
                    continue;
                }
                if ("name".equals(key) || "id".equals(key)) {
                    tokens.put(value, writeToken);
                    continue;
                }
                if (!"labels".equals(key)) continue;
                Map<String, String> labels = GTSHelper.parseLabels(value);
                writeToken.setLabels(labels);
            }
            br.close();
            for (Object token : tokens.values()) {
                if (token instanceof ReadToken) {
                    ReadToken rt = (ReadToken)token;
                    if (!rt.isSetBilledId()) {
                        rt.setBilledId(Tokens.getUUID("00000000-0000-0000-0000-000000000000"));
                    }
                    rt.setTokenType(TokenType.READ);
                    if (rt.isSetExpiryTimestamp()) continue;
                    rt.setExpiryTimestamp(Long.MAX_VALUE);
                    continue;
                }
                if (!(token instanceof WriteToken)) continue;
                WriteToken wt = (WriteToken)token;
                wt.setTokenType(TokenType.WRITE);
                if (wt.isSetExpiryTimestamp()) continue;
                wt.setExpiryTimestamp(Long.MAX_VALUE);
            }
            Map<String, Object> map = fileTokens;
            synchronized (map) {
                fileTokens.clear();
                fileTokens.putAll(tokens);
            }
        }
        catch (Exception e) {
            LOG.error("Error loading tokens file.", (Throwable)e);
            return;
        }
    }

    public static final void init(final String file) {
        Thread t = new Thread(){
            private long lastLoad = System.currentTimeMillis();

            @Override
            public void run() {
                while (!WarpDist.isInitialized()) {
                    LockSupport.parkNanos(1000000L);
                }
                Tokens.loadTokens(file);
                while (true) {
                    long now;
                    if ((now = System.currentTimeMillis()) - this.lastLoad > 60000L) {
                        Tokens.loadTokens(file);
                        this.lastLoad = now;
                    }
                    LockSupport.parkNanos(60000000000L);
                }
            }
        };
        t.setName("[Token Manager]");
        t.setDaemon(true);
        t.start();
    }

    public static final void register(AuthenticationPlugin plugin) {
        plugins.add(plugin);
    }

    static {
        plugins = new ArrayList<AuthenticationPlugin>();
        skipCheckAttributes = new ThreadLocal<Boolean>(){

            @Override
            protected Boolean initialValue() {
                return Boolean.FALSE;
            }
        };
        if (null != WarpConfig.getProperty("warp.token.banned.attributes")) {
            String[] attr = WarpConfig.getProperty("warp.token.banned.attributes").split(",");
            blockedAttributes = new ArrayList<String>();
            for (String a : attr) {
                blockedAttributes.add(a.trim());
            }
        } else {
            blockedAttributes = null;
        }
    }
}

