/*
 * Decompiled with CFR 0.152.
 */
package io.warp10;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.jar.JarFile;
import java.util.zip.ZipEntry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WarpClassLoader
extends ClassLoader {
    private static final Logger LOG = LoggerFactory.getLogger(WarpClassLoader.class);
    private final String jarpath;
    private final Map<String, Class> knownClasses;

    public WarpClassLoader(String jarpath, ClassLoader parent) {
        super(parent);
        this.jarpath = jarpath;
        this.knownClasses = new HashMap<String, Class>();
        WarpClassLoader.registerAsParallelCapable();
    }

    @Override
    public Class<?> loadClass(String name) throws ClassNotFoundException {
        return this.loadClass(name, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Class<?> loadClass(String name, boolean resolve) throws ClassNotFoundException {
        try {
            Class<?> c = this.findClass(name);
            if (resolve) {
                super.resolveClass(c);
            }
            Class<?> clazz = c;
            return clazz;
        }
        catch (ClassNotFoundException cnfe) {
            Class<?> clazz = super.loadClass(name, resolve);
            return clazz;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Class<?> findClass(String name) throws ClassNotFoundException {
        Class knownClass = this.knownClasses.get(name);
        if (null != knownClass) {
            return knownClass;
        }
        String clsFile = name.replace('.', '/') + ".class";
        JarFile jf = null;
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        InputStream in = null;
        try {
            int len;
            jf = new JarFile(this.jarpath);
            ZipEntry entry = jf.getEntry(clsFile);
            if (null == entry) {
                throw new ClassNotFoundException();
            }
            in = jf.getInputStream(entry);
            if (null == in) {
                Class<?> clazz = null;
                return clazz;
            }
            byte[] buffer = new byte[1024];
            while (-1 != (len = in.read(buffer, 0, buffer.length))) {
                out.write(buffer, 0, len);
            }
        }
        catch (IOException ioe) {
            throw new ClassNotFoundException("", ioe);
        }
        finally {
            if (null != in) {
                try {
                    in.close();
                }
                catch (IOException iOException) {}
            }
            if (null != jf) {
                try {
                    jf.close();
                }
                catch (IOException iOException) {}
            }
        }
        byte[] data = out.toByteArray();
        try {
            Class<?> c = null;
            String string = name.intern();
            synchronized (string) {
                knownClass = this.knownClasses.get(name);
                if (null != knownClass) {
                    return knownClass;
                }
                c = this.defineClass(name, data, 0, data.length);
                this.knownClasses.put(name, c);
            }
            return c;
        }
        catch (Throwable t) {
            throw new ClassNotFoundException("Error calling defineClass(" + name + ")", t);
        }
    }
}

