//
//   Copyright 2018  SenX S.A.S.
//
//   Licensed under the Apache License, Version 2.0 (the "License");
//   you may not use this file except in compliance with the License.
//   You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
//   Unless required by applicable law or agreed to in writing, software
//   distributed under the License is distributed on an "AS IS" BASIS,
//   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//   See the License for the specific language governing permissions and
//   limitations under the License.
//

package io.warp10.script.fwt.wavelets;

import io.warp10.script.fwt.Wavelet;

public class Wavelet_sym19 extends Wavelet {

  private static final int transformWavelength = 2;

  private static final double[] scalingDeComposition = new double[] { 5.487732768215838e-07, -6.463651303345963e-07, -1.1880518269823984e-05, 8.873312173729286e-06, 0.0001155392333357879, -4.612039600210587e-05, -0.000635764515004334, 0.00015915804768084938, 0.0021214250281823303, -0.0011607032572062486, -0.005122205002583014, 0.007968438320613306, 0.01579743929567463, -0.02265199337824595, -0.046635983534938946, 0.0070155738571741596, 0.008954591173043624, -0.06752505804029409, 0.10902582508127781, 0.578144945338605, 0.7195555257163943, 0.2582661692372836, -0.17659686625203097, -0.11624173010739675, 0.09363084341589714, 0.08407267627924504, -0.016908234861345205, -0.02770989693131125, 0.004319351874894969, 0.008262236955528255, -0.0006179223277983108, -0.0017049602611649971, 0.00012930767650701415, 0.0002762187768573407, -1.6821387029373716e-05, -2.8151138661550245e-05, 2.0623170632395688e-06, 1.7509367995348687e-06,  };
  private static final double[] waveletDeComposition = new double[] { -1.7509367995348687e-06, 2.0623170632395688e-06, 2.8151138661550245e-05, -1.6821387029373716e-05, -0.0002762187768573407, 0.00012930767650701415, 0.0017049602611649971, -0.0006179223277983108, -0.008262236955528255, 0.004319351874894969, 0.02770989693131125, -0.016908234861345205, -0.08407267627924504, 0.09363084341589714, 0.11624173010739675, -0.17659686625203097, -0.2582661692372836, 0.7195555257163943, -0.578144945338605, 0.10902582508127781, 0.06752505804029409, 0.008954591173043624, -0.0070155738571741596, -0.046635983534938946, 0.02265199337824595, 0.01579743929567463, -0.007968438320613306, -0.005122205002583014, 0.0011607032572062486, 0.0021214250281823303, -0.00015915804768084938, -0.000635764515004334, 4.612039600210587e-05, 0.0001155392333357879, -8.873312173729286e-06, -1.1880518269823984e-05, 6.463651303345963e-07, 5.487732768215838e-07,  };

  private static final double[] scalingReConstruction = new double[] { 1.7509367995348687e-06, 2.0623170632395688e-06, -2.8151138661550245e-05, -1.6821387029373716e-05, 0.0002762187768573407, 0.00012930767650701415, -0.0017049602611649971, -0.0006179223277983108, 0.008262236955528255, 0.004319351874894969, -0.02770989693131125, -0.016908234861345205, 0.08407267627924504, 0.09363084341589714, -0.11624173010739675, -0.17659686625203097, 0.2582661692372836, 0.7195555257163943, 0.578144945338605, 0.10902582508127781, -0.06752505804029409, 0.008954591173043624, 0.0070155738571741596, -0.046635983534938946, -0.02265199337824595, 0.01579743929567463, 0.007968438320613306, -0.005122205002583014, -0.0011607032572062486, 0.0021214250281823303, 0.00015915804768084938, -0.000635764515004334, -4.612039600210587e-05, 0.0001155392333357879, 8.873312173729286e-06, -1.1880518269823984e-05, -6.463651303345963e-07, 5.487732768215838e-07,  };
  private static final double[] waveletReConstruction = new double[] { 5.487732768215838e-07, 6.463651303345963e-07, -1.1880518269823984e-05, -8.873312173729286e-06, 0.0001155392333357879, 4.612039600210587e-05, -0.000635764515004334, -0.00015915804768084938, 0.0021214250281823303, 0.0011607032572062486, -0.005122205002583014, -0.007968438320613306, 0.01579743929567463, 0.02265199337824595, -0.046635983534938946, -0.0070155738571741596, 0.008954591173043624, 0.06752505804029409, 0.10902582508127781, -0.578144945338605, 0.7195555257163943, -0.2582661692372836, -0.17659686625203097, 0.11624173010739675, 0.09363084341589714, -0.08407267627924504, -0.016908234861345205, 0.02770989693131125, 0.004319351874894969, -0.008262236955528255, -0.0006179223277983108, 0.0017049602611649971, 0.00012930767650701415, -0.0002762187768573407, -1.6821387029373716e-05, 2.8151138661550245e-05, 2.0623170632395688e-06, -1.7509367995348687e-06,  };

  static {
    //
    // Reverse the arrays as we do convolutions
    //
    reverse(scalingDeComposition);
    reverse(waveletDeComposition);
  }

  private static final void reverse(double[] array) {
    int i = 0;
    int j = array.length - 1;
    
    while (i < j) {
      double tmp = array[i];
      array[i] = array[j];
      array[j] = tmp;
      i++;
      j--;
    }
  }

  public int getTransformWavelength() {
    return transformWavelength;
  }

  public int getMotherWavelength() {
    return waveletReConstruction.length;
  }

  public double[] getScalingDeComposition() {
    return scalingDeComposition;
  }

  public double[] getWaveletDeComposition() {
    return waveletDeComposition;
  }

  public double[] getScalingReConstruction() {
    return scalingReConstruction;
  }

  public double[] getWaveletReConstruction() {
    return waveletReConstruction;
  }
}

