//
//   Copyright 2018  SenX S.A.S.
//
//   Licensed under the Apache License, Version 2.0 (the "License");
//   you may not use this file except in compliance with the License.
//   You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
//   Unless required by applicable law or agreed to in writing, software
//   distributed under the License is distributed on an "AS IS" BASIS,
//   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//   See the License for the specific language governing permissions and
//   limitations under the License.
//

package io.warp10.script.fwt.wavelets;

import io.warp10.script.fwt.Wavelet;

public class Wavelet_sym18 extends Wavelet {

  private static final int transformWavelength = 2;

  private static final double[] scalingDeComposition = new double[] { 2.6126125564836423e-06, 1.354915761832114e-06, -4.5246757874949856e-05, -1.4020992577726755e-05, 0.00039616840638254753, 7.021273459036268e-05, -0.002313871814506099, -0.00041152110923597756, 0.009502164390962365, 0.001642986397278216, -0.030325091089369604, -0.005077085160757053, 0.08421992997038655, 0.03399566710394736, -0.15993814866932407, -0.052029158983952786, 0.47396905989393956, 0.7536291401017928, 0.40148386057061813, -0.032480573290138676, -0.07379920729060717, 0.028529597039037808, 0.006277944554311694, -0.03171268473181454, -0.0032607442000749834, 0.015012356344250213, 0.001087784789595693, -0.005239789683026608, -0.00018877623940755607, 0.0014280863270832796, 4.741614518373667e-05, -0.0002658301102424104, -9.858816030140058e-06, 2.955743762093081e-05, 7.847298055831765e-07, -1.5131530692371587e-06,  };
  private static final double[] waveletDeComposition = new double[] { 1.5131530692371587e-06, 7.847298055831765e-07, -2.955743762093081e-05, -9.858816030140058e-06, 0.0002658301102424104, 4.741614518373667e-05, -0.0014280863270832796, -0.00018877623940755607, 0.005239789683026608, 0.001087784789595693, -0.015012356344250213, -0.0032607442000749834, 0.03171268473181454, 0.006277944554311694, -0.028529597039037808, -0.07379920729060717, 0.032480573290138676, 0.40148386057061813, -0.7536291401017928, 0.47396905989393956, 0.052029158983952786, -0.15993814866932407, -0.03399566710394736, 0.08421992997038655, 0.005077085160757053, -0.030325091089369604, -0.001642986397278216, 0.009502164390962365, 0.00041152110923597756, -0.002313871814506099, -7.021273459036268e-05, 0.00039616840638254753, 1.4020992577726755e-05, -4.5246757874949856e-05, -1.354915761832114e-06, 2.6126125564836423e-06,  };

  private static final double[] scalingReConstruction = new double[] { -1.5131530692371587e-06, 7.847298055831765e-07, 2.955743762093081e-05, -9.858816030140058e-06, -0.0002658301102424104, 4.741614518373667e-05, 0.0014280863270832796, -0.00018877623940755607, -0.005239789683026608, 0.001087784789595693, 0.015012356344250213, -0.0032607442000749834, -0.03171268473181454, 0.006277944554311694, 0.028529597039037808, -0.07379920729060717, -0.032480573290138676, 0.40148386057061813, 0.7536291401017928, 0.47396905989393956, -0.052029158983952786, -0.15993814866932407, 0.03399566710394736, 0.08421992997038655, -0.005077085160757053, -0.030325091089369604, 0.001642986397278216, 0.009502164390962365, -0.00041152110923597756, -0.002313871814506099, 7.021273459036268e-05, 0.00039616840638254753, -1.4020992577726755e-05, -4.5246757874949856e-05, 1.354915761832114e-06, 2.6126125564836423e-06,  };
  private static final double[] waveletReConstruction = new double[] { 2.6126125564836423e-06, -1.354915761832114e-06, -4.5246757874949856e-05, 1.4020992577726755e-05, 0.00039616840638254753, -7.021273459036268e-05, -0.002313871814506099, 0.00041152110923597756, 0.009502164390962365, -0.001642986397278216, -0.030325091089369604, 0.005077085160757053, 0.08421992997038655, -0.03399566710394736, -0.15993814866932407, 0.052029158983952786, 0.47396905989393956, -0.7536291401017928, 0.40148386057061813, 0.032480573290138676, -0.07379920729060717, -0.028529597039037808, 0.006277944554311694, 0.03171268473181454, -0.0032607442000749834, -0.015012356344250213, 0.001087784789595693, 0.005239789683026608, -0.00018877623940755607, -0.0014280863270832796, 4.741614518373667e-05, 0.0002658301102424104, -9.858816030140058e-06, -2.955743762093081e-05, 7.847298055831765e-07, 1.5131530692371587e-06,  };

  static {
    //
    // Reverse the arrays as we do convolutions
    //
    reverse(scalingDeComposition);
    reverse(waveletDeComposition);
  }

  private static final void reverse(double[] array) {
    int i = 0;
    int j = array.length - 1;
    
    while (i < j) {
      double tmp = array[i];
      array[i] = array[j];
      array[j] = tmp;
      i++;
      j--;
    }
  }

  public int getTransformWavelength() {
    return transformWavelength;
  }

  public int getMotherWavelength() {
    return waveletReConstruction.length;
  }

  public double[] getScalingDeComposition() {
    return scalingDeComposition;
  }

  public double[] getWaveletDeComposition() {
    return waveletDeComposition;
  }

  public double[] getScalingReConstruction() {
    return scalingReConstruction;
  }

  public double[] getWaveletReConstruction() {
    return waveletReConstruction;
  }
}

