//
//   Copyright 2018  SenX S.A.S.
//
//   Licensed under the Apache License, Version 2.0 (the "License");
//   you may not use this file except in compliance with the License.
//   You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
//   Unless required by applicable law or agreed to in writing, software
//   distributed under the License is distributed on an "AS IS" BASIS,
//   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//   See the License for the specific language governing permissions and
//   limitations under the License.
//

package io.warp10.script.fwt.wavelets;

import io.warp10.script.fwt.Wavelet;

public class Wavelet_sym16 extends Wavelet {

  private static final int transformWavelength = 2;

  private static final double[] scalingDeComposition = new double[] { 6.230006701220761e-06, -3.113556407621969e-06, -0.00010943147929529757, 2.8078582128442894e-05, 0.0008523547108047095, -0.0001084456223089688, -0.0038809122526038786, 0.0007182119788317892, 0.012666731659857348, -0.0031265171722710075, -0.031051202843553064, 0.004869274404904607, 0.032333091610663785, -0.06698304907021778, -0.034574228416972504, 0.39712293362064416, 0.7565249878756971, 0.47534280601152273, -0.054040601387606135, -0.15959219218520598, 0.03072113906330156, 0.07803785290341991, -0.003510275068374009, -0.024952758046290123, 0.001359844742484172, 0.0069377611308027096, -0.00022211647621176323, -0.0013387206066921965, 3.656592483348223e-05, 0.00016545679579108483, -5.396483179315242e-06, -1.0797982104319795e-05,  };
  private static final double[] waveletDeComposition = new double[] { 1.0797982104319795e-05, -5.396483179315242e-06, -0.00016545679579108483, 3.656592483348223e-05, 0.0013387206066921965, -0.00022211647621176323, -0.0069377611308027096, 0.001359844742484172, 0.024952758046290123, -0.003510275068374009, -0.07803785290341991, 0.03072113906330156, 0.15959219218520598, -0.054040601387606135, -0.47534280601152273, 0.7565249878756971, -0.39712293362064416, -0.034574228416972504, 0.06698304907021778, 0.032333091610663785, -0.004869274404904607, -0.031051202843553064, 0.0031265171722710075, 0.012666731659857348, -0.0007182119788317892, -0.0038809122526038786, 0.0001084456223089688, 0.0008523547108047095, -2.8078582128442894e-05, -0.00010943147929529757, 3.113556407621969e-06, 6.230006701220761e-06,  };

  private static final double[] scalingReConstruction = new double[] { -1.0797982104319795e-05, -5.396483179315242e-06, 0.00016545679579108483, 3.656592483348223e-05, -0.0013387206066921965, -0.00022211647621176323, 0.0069377611308027096, 0.001359844742484172, -0.024952758046290123, -0.003510275068374009, 0.07803785290341991, 0.03072113906330156, -0.15959219218520598, -0.054040601387606135, 0.47534280601152273, 0.7565249878756971, 0.39712293362064416, -0.034574228416972504, -0.06698304907021778, 0.032333091610663785, 0.004869274404904607, -0.031051202843553064, -0.0031265171722710075, 0.012666731659857348, 0.0007182119788317892, -0.0038809122526038786, -0.0001084456223089688, 0.0008523547108047095, 2.8078582128442894e-05, -0.00010943147929529757, -3.113556407621969e-06, 6.230006701220761e-06,  };
  private static final double[] waveletReConstruction = new double[] { 6.230006701220761e-06, 3.113556407621969e-06, -0.00010943147929529757, -2.8078582128442894e-05, 0.0008523547108047095, 0.0001084456223089688, -0.0038809122526038786, -0.0007182119788317892, 0.012666731659857348, 0.0031265171722710075, -0.031051202843553064, -0.004869274404904607, 0.032333091610663785, 0.06698304907021778, -0.034574228416972504, -0.39712293362064416, 0.7565249878756971, -0.47534280601152273, -0.054040601387606135, 0.15959219218520598, 0.03072113906330156, -0.07803785290341991, -0.003510275068374009, 0.024952758046290123, 0.001359844742484172, -0.0069377611308027096, -0.00022211647621176323, 0.0013387206066921965, 3.656592483348223e-05, -0.00016545679579108483, -5.396483179315242e-06, 1.0797982104319795e-05,  };

  static {
    //
    // Reverse the arrays as we do convolutions
    //
    reverse(scalingDeComposition);
    reverse(waveletDeComposition);
  }

  private static final void reverse(double[] array) {
    int i = 0;
    int j = array.length - 1;
    
    while (i < j) {
      double tmp = array[i];
      array[i] = array[j];
      array[j] = tmp;
      i++;
      j--;
    }
  }

  public int getTransformWavelength() {
    return transformWavelength;
  }

  public int getMotherWavelength() {
    return waveletReConstruction.length;
  }

  public double[] getScalingDeComposition() {
    return scalingDeComposition;
  }

  public double[] getWaveletDeComposition() {
    return waveletDeComposition;
  }

  public double[] getScalingReConstruction() {
    return scalingReConstruction;
  }

  public double[] getWaveletReConstruction() {
    return waveletReConstruction;
  }
}

