//
//   Copyright 2018  SenX S.A.S.
//
//   Licensed under the Apache License, Version 2.0 (the "License");
//   you may not use this file except in compliance with the License.
//   You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
//   Unless required by applicable law or agreed to in writing, software
//   distributed under the License is distributed on an "AS IS" BASIS,
//   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//   See the License for the specific language governing permissions and
//   limitations under the License.
//

package io.warp10.script.fwt.wavelets;

import io.warp10.script.fwt.Wavelet;

public class Wavelet_sym15 extends Wavelet {

  private static final int transformWavelength = 2;

  private static final double[] scalingDeComposition = new double[] { 9.712419737963348e-06, -7.35966679891947e-06, -0.00016066186637495343, 5.512254785558665e-05, 0.0010705672194623959, -0.0002673164464718057, -0.0035901654473726417, 0.003423450736351241, 0.01007997708790567, -0.01940501143093447, -0.03887671687683349, 0.021937642719753955, 0.04073547969681068, -0.04108266663538248, 0.11153369514261872, 0.5786404152150345, 0.7218430296361812, 0.2439627054321663, -0.1966263587662373, -0.1340562984562539, 0.06839331006048024, 0.06796982904487918, -0.008744788886477952, -0.01717125278163873, 0.0015261382781819983, 0.003481028737064895, -0.00010815440168545525, -0.00040216853760293483, 2.171789015077892e-05, 2.866070852531808e-05,  };
  private static final double[] waveletDeComposition = new double[] { -2.866070852531808e-05, 2.171789015077892e-05, 0.00040216853760293483, -0.00010815440168545525, -0.003481028737064895, 0.0015261382781819983, 0.01717125278163873, -0.008744788886477952, -0.06796982904487918, 0.06839331006048024, 0.1340562984562539, -0.1966263587662373, -0.2439627054321663, 0.7218430296361812, -0.5786404152150345, 0.11153369514261872, 0.04108266663538248, 0.04073547969681068, -0.021937642719753955, -0.03887671687683349, 0.01940501143093447, 0.01007997708790567, -0.003423450736351241, -0.0035901654473726417, 0.0002673164464718057, 0.0010705672194623959, -5.512254785558665e-05, -0.00016066186637495343, 7.35966679891947e-06, 9.712419737963348e-06,  };

  private static final double[] scalingReConstruction = new double[] { 2.866070852531808e-05, 2.171789015077892e-05, -0.00040216853760293483, -0.00010815440168545525, 0.003481028737064895, 0.0015261382781819983, -0.01717125278163873, -0.008744788886477952, 0.06796982904487918, 0.06839331006048024, -0.1340562984562539, -0.1966263587662373, 0.2439627054321663, 0.7218430296361812, 0.5786404152150345, 0.11153369514261872, -0.04108266663538248, 0.04073547969681068, 0.021937642719753955, -0.03887671687683349, -0.01940501143093447, 0.01007997708790567, 0.003423450736351241, -0.0035901654473726417, -0.0002673164464718057, 0.0010705672194623959, 5.512254785558665e-05, -0.00016066186637495343, -7.35966679891947e-06, 9.712419737963348e-06,  };
  private static final double[] waveletReConstruction = new double[] { 9.712419737963348e-06, 7.35966679891947e-06, -0.00016066186637495343, -5.512254785558665e-05, 0.0010705672194623959, 0.0002673164464718057, -0.0035901654473726417, -0.003423450736351241, 0.01007997708790567, 0.01940501143093447, -0.03887671687683349, -0.021937642719753955, 0.04073547969681068, 0.04108266663538248, 0.11153369514261872, -0.5786404152150345, 0.7218430296361812, -0.2439627054321663, -0.1966263587662373, 0.1340562984562539, 0.06839331006048024, -0.06796982904487918, -0.008744788886477952, 0.01717125278163873, 0.0015261382781819983, -0.003481028737064895, -0.00010815440168545525, 0.00040216853760293483, 2.171789015077892e-05, -2.866070852531808e-05,  };

  static {
    //
    // Reverse the arrays as we do convolutions
    //
    reverse(scalingDeComposition);
    reverse(waveletDeComposition);
  }

  private static final void reverse(double[] array) {
    int i = 0;
    int j = array.length - 1;
    
    while (i < j) {
      double tmp = array[i];
      array[i] = array[j];
      array[j] = tmp;
      i++;
      j--;
    }
  }

  public int getTransformWavelength() {
    return transformWavelength;
  }

  public int getMotherWavelength() {
    return waveletReConstruction.length;
  }

  public double[] getScalingDeComposition() {
    return scalingDeComposition;
  }

  public double[] getWaveletDeComposition() {
    return waveletDeComposition;
  }

  public double[] getScalingReConstruction() {
    return scalingReConstruction;
  }

  public double[] getWaveletReConstruction() {
    return waveletReConstruction;
  }
}

