//
//   Copyright 2018  SenX S.A.S.
//
//   Licensed under the Apache License, Version 2.0 (the "License");
//   you may not use this file except in compliance with the License.
//   You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
//   Unless required by applicable law or agreed to in writing, software
//   distributed under the License is distributed on an "AS IS" BASIS,
//   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//   See the License for the specific language governing permissions and
//   limitations under the License.
//

package io.warp10.script.fwt.wavelets;

import io.warp10.script.fwt.Wavelet;

public class Wavelet_db19 extends Wavelet {

  private static final int transformWavelength = 2;

  private static final double[] scalingDeComposition = new double[] { 8.666848839034483e-10, -1.1164020670405678e-08, 4.636937775802368e-08, 1.447088298804088e-08, -6.86275565779811e-07, 1.531931476697877e-06, 3.0109643163099385e-06, -1.664017629722462e-05, 5.105950487090694e-06, 8.711270467250443e-05, -0.00012460079173506306, -0.0002606761356811995, 0.0007358025205041731, 0.00034180865344939543, -0.002687551800734441, 0.0007689543592242488, 0.007040747367080495, -0.005866922281112195, -0.013988388678695632, 0.019375549889114482, 0.021623767409452484, -0.04567422627778492, -0.026501236250778635, 0.0869067555554507, 0.02758435062488713, -0.14278569504021468, -0.03351854190320226, 0.21234974330662043, 0.07465226970806647, -0.28583863175723145, -0.22809139421653665, 0.2608949526521201, 0.6017045491300916, 0.5244363774668862, 0.26438843174202237, 0.08127811326580564, 0.01428109845082521, 0.0011086697631864314,  };
  private static final double[] waveletDeComposition = new double[] { -0.0011086697631864314, 0.01428109845082521, -0.08127811326580564, 0.26438843174202237, -0.5244363774668862, 0.6017045491300916, -0.2608949526521201, -0.22809139421653665, 0.28583863175723145, 0.07465226970806647, -0.21234974330662043, -0.03351854190320226, 0.14278569504021468, 0.02758435062488713, -0.0869067555554507, -0.026501236250778635, 0.04567422627778492, 0.021623767409452484, -0.019375549889114482, -0.013988388678695632, 0.005866922281112195, 0.007040747367080495, -0.0007689543592242488, -0.002687551800734441, -0.00034180865344939543, 0.0007358025205041731, 0.0002606761356811995, -0.00012460079173506306, -8.711270467250443e-05, 5.105950487090694e-06, 1.664017629722462e-05, 3.0109643163099385e-06, -1.531931476697877e-06, -6.86275565779811e-07, -1.447088298804088e-08, 4.636937775802368e-08, 1.1164020670405678e-08, 8.666848839034483e-10,  };

  private static final double[] scalingReConstruction = new double[] { 0.0011086697631864314, 0.01428109845082521, 0.08127811326580564, 0.26438843174202237, 0.5244363774668862, 0.6017045491300916, 0.2608949526521201, -0.22809139421653665, -0.28583863175723145, 0.07465226970806647, 0.21234974330662043, -0.03351854190320226, -0.14278569504021468, 0.02758435062488713, 0.0869067555554507, -0.026501236250778635, -0.04567422627778492, 0.021623767409452484, 0.019375549889114482, -0.013988388678695632, -0.005866922281112195, 0.007040747367080495, 0.0007689543592242488, -0.002687551800734441, 0.00034180865344939543, 0.0007358025205041731, -0.0002606761356811995, -0.00012460079173506306, 8.711270467250443e-05, 5.105950487090694e-06, -1.664017629722462e-05, 3.0109643163099385e-06, 1.531931476697877e-06, -6.86275565779811e-07, 1.447088298804088e-08, 4.636937775802368e-08, -1.1164020670405678e-08, 8.666848839034483e-10,  };
  private static final double[] waveletReConstruction = new double[] { 8.666848839034483e-10, 1.1164020670405678e-08, 4.636937775802368e-08, -1.447088298804088e-08, -6.86275565779811e-07, -1.531931476697877e-06, 3.0109643163099385e-06, 1.664017629722462e-05, 5.105950487090694e-06, -8.711270467250443e-05, -0.00012460079173506306, 0.0002606761356811995, 0.0007358025205041731, -0.00034180865344939543, -0.002687551800734441, -0.0007689543592242488, 0.007040747367080495, 0.005866922281112195, -0.013988388678695632, -0.019375549889114482, 0.021623767409452484, 0.04567422627778492, -0.026501236250778635, -0.0869067555554507, 0.02758435062488713, 0.14278569504021468, -0.03351854190320226, -0.21234974330662043, 0.07465226970806647, 0.28583863175723145, -0.22809139421653665, -0.2608949526521201, 0.6017045491300916, -0.5244363774668862, 0.26438843174202237, -0.08127811326580564, 0.01428109845082521, -0.0011086697631864314,  };

  static {
    //
    // Reverse the arrays as we do convolutions
    //
    reverse(scalingDeComposition);
    reverse(waveletDeComposition);
  }

  private static final void reverse(double[] array) {
    int i = 0;
    int j = array.length - 1;
    
    while (i < j) {
      double tmp = array[i];
      array[i] = array[j];
      array[j] = tmp;
      i++;
      j--;
    }
  }

  public int getTransformWavelength() {
    return transformWavelength;
  }

  public int getMotherWavelength() {
    return waveletReConstruction.length;
  }

  public double[] getScalingDeComposition() {
    return scalingDeComposition;
  }

  public double[] getWaveletDeComposition() {
    return waveletDeComposition;
  }

  public double[] getScalingReConstruction() {
    return scalingReConstruction;
  }

  public double[] getWaveletReConstruction() {
    return waveletReConstruction;
  }
}

