//
//   Copyright 2018  SenX S.A.S.
//
//   Licensed under the Apache License, Version 2.0 (the "License");
//   you may not use this file except in compliance with the License.
//   You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
//   Unless required by applicable law or agreed to in writing, software
//   distributed under the License is distributed on an "AS IS" BASIS,
//   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//   See the License for the specific language governing permissions and
//   limitations under the License.
//

package io.warp10.script.fwt.wavelets;

import io.warp10.script.fwt.Wavelet;

public class Wavelet_db16 extends Wavelet {

  private static final int transformWavelength = 2;

  private static final double[] scalingDeComposition = new double[] { -2.1093396300980412e-08, 2.3087840868545578e-07, -7.363656785441815e-07, -1.0435713423102517e-06, 1.133660866126152e-05, -1.394566898819319e-05, -6.103596621404321e-05, 0.00017478724522506327, 0.00011424152003843815, -0.0009410217493585433, 0.00040789698084934395, 0.00312802338120381, -0.0036442796214883506, -0.006990014563390751, 0.013993768859843242, 0.010297659641009963, -0.036888397691556774, -0.007588974368642594, 0.07592423604445779, -0.006239722752156254, -0.13238830556335474, 0.027340263752899923, 0.21119069394696974, -0.02791820813292813, -0.3270633105274758, -0.08975108940236352, 0.44029025688580486, 0.6373563320829833, 0.43031272284545874, 0.1650642834886438, 0.03490771432362905, 0.0031892209253436892,  };
  private static final double[] waveletDeComposition = new double[] { -0.0031892209253436892, 0.03490771432362905, -0.1650642834886438, 0.43031272284545874, -0.6373563320829833, 0.44029025688580486, 0.08975108940236352, -0.3270633105274758, 0.02791820813292813, 0.21119069394696974, -0.027340263752899923, -0.13238830556335474, 0.006239722752156254, 0.07592423604445779, 0.007588974368642594, -0.036888397691556774, -0.010297659641009963, 0.013993768859843242, 0.006990014563390751, -0.0036442796214883506, -0.00312802338120381, 0.00040789698084934395, 0.0009410217493585433, 0.00011424152003843815, -0.00017478724522506327, -6.103596621404321e-05, 1.394566898819319e-05, 1.133660866126152e-05, 1.0435713423102517e-06, -7.363656785441815e-07, -2.3087840868545578e-07, -2.1093396300980412e-08,  };

  private static final double[] scalingReConstruction = new double[] { 0.0031892209253436892, 0.03490771432362905, 0.1650642834886438, 0.43031272284545874, 0.6373563320829833, 0.44029025688580486, -0.08975108940236352, -0.3270633105274758, -0.02791820813292813, 0.21119069394696974, 0.027340263752899923, -0.13238830556335474, -0.006239722752156254, 0.07592423604445779, -0.007588974368642594, -0.036888397691556774, 0.010297659641009963, 0.013993768859843242, -0.006990014563390751, -0.0036442796214883506, 0.00312802338120381, 0.00040789698084934395, -0.0009410217493585433, 0.00011424152003843815, 0.00017478724522506327, -6.103596621404321e-05, -1.394566898819319e-05, 1.133660866126152e-05, -1.0435713423102517e-06, -7.363656785441815e-07, 2.3087840868545578e-07, -2.1093396300980412e-08,  };
  private static final double[] waveletReConstruction = new double[] { -2.1093396300980412e-08, -2.3087840868545578e-07, -7.363656785441815e-07, 1.0435713423102517e-06, 1.133660866126152e-05, 1.394566898819319e-05, -6.103596621404321e-05, -0.00017478724522506327, 0.00011424152003843815, 0.0009410217493585433, 0.00040789698084934395, -0.00312802338120381, -0.0036442796214883506, 0.006990014563390751, 0.013993768859843242, -0.010297659641009963, -0.036888397691556774, 0.007588974368642594, 0.07592423604445779, 0.006239722752156254, -0.13238830556335474, -0.027340263752899923, 0.21119069394696974, 0.02791820813292813, -0.3270633105274758, 0.08975108940236352, 0.44029025688580486, -0.6373563320829833, 0.43031272284545874, -0.1650642834886438, 0.03490771432362905, -0.0031892209253436892,  };

  static {
    //
    // Reverse the arrays as we do convolutions
    //
    reverse(scalingDeComposition);
    reverse(waveletDeComposition);
  }

  private static final void reverse(double[] array) {
    int i = 0;
    int j = array.length - 1;
    
    while (i < j) {
      double tmp = array[i];
      array[i] = array[j];
      array[j] = tmp;
      i++;
      j--;
    }
  }

  public int getTransformWavelength() {
    return transformWavelength;
  }

  public int getMotherWavelength() {
    return waveletReConstruction.length;
  }

  public double[] getScalingDeComposition() {
    return scalingDeComposition;
  }

  public double[] getWaveletDeComposition() {
    return waveletDeComposition;
  }

  public double[] getScalingReConstruction() {
    return scalingReConstruction;
  }

  public double[] getWaveletReConstruction() {
    return waveletReConstruction;
  }
}

