//
//   Copyright 2018  SenX S.A.S.
//
//   Licensed under the Apache License, Version 2.0 (the "License");
//   you may not use this file except in compliance with the License.
//   You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
//   Unless required by applicable law or agreed to in writing, software
//   distributed under the License is distributed on an "AS IS" BASIS,
//   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//   See the License for the specific language governing permissions and
//   limitations under the License.
//

package io.warp10.script.fwt.wavelets;

import io.warp10.script.fwt.Wavelet;

public class Wavelet_db15 extends Wavelet {

  private static final int transformWavelength = 2;

  private static final double[] scalingDeComposition = new double[] { 6.133359913303714e-08, -6.316882325879451e-07, 1.8112704079399406e-06, 3.3629871817363823e-06, -2.8133296266037558e-05, 2.579269915531323e-05, 0.00015589648992055726, -0.00035956524436229364, -0.0003734823541372647, 0.0019433239803823459, -0.00024175649075894543, -0.0064877345603061454, 0.005101000360422873, 0.015083918027862582, -0.020810050169636805, -0.02576700732836694, 0.054780550584559995, 0.033877143923563204, -0.11112093603713753, -0.0396661765557336, 0.19014671400708816, 0.06528295284876569, -0.28888259656686216, -0.19320413960907623, 0.33900253545462167, 0.6458131403572103, 0.4926317717079753, 0.20602386398692688, 0.04674339489275062, 0.004538537361577376,  };
  private static final double[] waveletDeComposition = new double[] { -0.004538537361577376, 0.04674339489275062, -0.20602386398692688, 0.4926317717079753, -0.6458131403572103, 0.33900253545462167, 0.19320413960907623, -0.28888259656686216, -0.06528295284876569, 0.19014671400708816, 0.0396661765557336, -0.11112093603713753, -0.033877143923563204, 0.054780550584559995, 0.02576700732836694, -0.020810050169636805, -0.015083918027862582, 0.005101000360422873, 0.0064877345603061454, -0.00024175649075894543, -0.0019433239803823459, -0.0003734823541372647, 0.00035956524436229364, 0.00015589648992055726, -2.579269915531323e-05, -2.8133296266037558e-05, -3.3629871817363823e-06, 1.8112704079399406e-06, 6.316882325879451e-07, 6.133359913303714e-08,  };

  private static final double[] scalingReConstruction = new double[] { 0.004538537361577376, 0.04674339489275062, 0.20602386398692688, 0.4926317717079753, 0.6458131403572103, 0.33900253545462167, -0.19320413960907623, -0.28888259656686216, 0.06528295284876569, 0.19014671400708816, -0.0396661765557336, -0.11112093603713753, 0.033877143923563204, 0.054780550584559995, -0.02576700732836694, -0.020810050169636805, 0.015083918027862582, 0.005101000360422873, -0.0064877345603061454, -0.00024175649075894543, 0.0019433239803823459, -0.0003734823541372647, -0.00035956524436229364, 0.00015589648992055726, 2.579269915531323e-05, -2.8133296266037558e-05, 3.3629871817363823e-06, 1.8112704079399406e-06, -6.316882325879451e-07, 6.133359913303714e-08,  };
  private static final double[] waveletReConstruction = new double[] { 6.133359913303714e-08, 6.316882325879451e-07, 1.8112704079399406e-06, -3.3629871817363823e-06, -2.8133296266037558e-05, -2.579269915531323e-05, 0.00015589648992055726, 0.00035956524436229364, -0.0003734823541372647, -0.0019433239803823459, -0.00024175649075894543, 0.0064877345603061454, 0.005101000360422873, -0.015083918027862582, -0.020810050169636805, 0.02576700732836694, 0.054780550584559995, -0.033877143923563204, -0.11112093603713753, 0.0396661765557336, 0.19014671400708816, -0.06528295284876569, -0.28888259656686216, 0.19320413960907623, 0.33900253545462167, -0.6458131403572103, 0.4926317717079753, -0.20602386398692688, 0.04674339489275062, -0.004538537361577376,  };

  static {
    //
    // Reverse the arrays as we do convolutions
    //
    reverse(scalingDeComposition);
    reverse(waveletDeComposition);
  }

  private static final void reverse(double[] array) {
    int i = 0;
    int j = array.length - 1;
    
    while (i < j) {
      double tmp = array[i];
      array[i] = array[j];
      array[j] = tmp;
      i++;
      j--;
    }
  }

  public int getTransformWavelength() {
    return transformWavelength;
  }

  public int getMotherWavelength() {
    return waveletReConstruction.length;
  }

  public double[] getScalingDeComposition() {
    return scalingDeComposition;
  }

  public double[] getWaveletDeComposition() {
    return waveletDeComposition;
  }

  public double[] getScalingReConstruction() {
    return scalingReConstruction;
  }

  public double[] getWaveletReConstruction() {
    return waveletReConstruction;
  }
}

