//
//   Copyright 2018  SenX S.A.S.
//
//   Licensed under the Apache License, Version 2.0 (the "License");
//   you may not use this file except in compliance with the License.
//   You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
//   Unless required by applicable law or agreed to in writing, software
//   distributed under the License is distributed on an "AS IS" BASIS,
//   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//   See the License for the specific language governing permissions and
//   limitations under the License.
//

package io.warp10.script.fwt.wavelets;

import io.warp10.script.fwt.Wavelet;

public class Wavelet_coif5 extends Wavelet {

  private static final int transformWavelength = 2;

  private static final double[] scalingDeComposition = new double[] { -9.517657273819165e-08, -1.6744288576823017e-07, 2.0637618513646814e-06, 3.7346551751414047e-06, -2.1315026809955787e-05, -4.134043227251251e-05, 0.00014054114970203437, 0.00030225958181306315, -0.0006381313430451114, -0.0016628637020130838, 0.0024333732126576722, 0.006764185448053083, -0.009164231162481846, -0.01976177894257264, 0.03268357426711183, 0.0412892087501817, -0.10557420870333893, -0.06203596396290357, 0.4379916261718371, 0.7742896036529562, 0.4215662066908515, -0.05204316317624377, -0.09192001055969624, 0.02816802897093635, 0.023408156785839195, -0.010131117519849788, -0.004159358781386048, 0.0021782363581090178, 0.00035858968789573785, -0.00021208083980379827,  };
  private static final double[] waveletDeComposition = new double[] { 0.00021208083980379827, 0.00035858968789573785, -0.0021782363581090178, -0.004159358781386048, 0.010131117519849788, 0.023408156785839195, -0.02816802897093635, -0.09192001055969624, 0.05204316317624377, 0.4215662066908515, -0.7742896036529562, 0.4379916261718371, 0.06203596396290357, -0.10557420870333893, -0.0412892087501817, 0.03268357426711183, 0.01976177894257264, -0.009164231162481846, -0.006764185448053083, 0.0024333732126576722, 0.0016628637020130838, -0.0006381313430451114, -0.00030225958181306315, 0.00014054114970203437, 4.134043227251251e-05, -2.1315026809955787e-05, -3.7346551751414047e-06, 2.0637618513646814e-06, 1.6744288576823017e-07, -9.517657273819165e-08,  };

  private static final double[] scalingReConstruction = new double[] { -0.00021208083980379827, 0.00035858968789573785, 0.0021782363581090178, -0.004159358781386048, -0.010131117519849788, 0.023408156785839195, 0.02816802897093635, -0.09192001055969624, -0.05204316317624377, 0.4215662066908515, 0.7742896036529562, 0.4379916261718371, -0.06203596396290357, -0.10557420870333893, 0.0412892087501817, 0.03268357426711183, -0.01976177894257264, -0.009164231162481846, 0.006764185448053083, 0.0024333732126576722, -0.0016628637020130838, -0.0006381313430451114, 0.00030225958181306315, 0.00014054114970203437, -4.134043227251251e-05, -2.1315026809955787e-05, 3.7346551751414047e-06, 2.0637618513646814e-06, -1.6744288576823017e-07, -9.517657273819165e-08,  };
  private static final double[] waveletReConstruction = new double[] { -9.517657273819165e-08, 1.6744288576823017e-07, 2.0637618513646814e-06, -3.7346551751414047e-06, -2.1315026809955787e-05, 4.134043227251251e-05, 0.00014054114970203437, -0.00030225958181306315, -0.0006381313430451114, 0.0016628637020130838, 0.0024333732126576722, -0.006764185448053083, -0.009164231162481846, 0.01976177894257264, 0.03268357426711183, -0.0412892087501817, -0.10557420870333893, 0.06203596396290357, 0.4379916261718371, -0.7742896036529562, 0.4215662066908515, 0.05204316317624377, -0.09192001055969624, -0.02816802897093635, 0.023408156785839195, 0.010131117519849788, -0.004159358781386048, -0.0021782363581090178, 0.00035858968789573785, 0.00021208083980379827,  };

  static {
    //
    // Reverse the arrays as we do convolutions
    //
    reverse(scalingDeComposition);
    reverse(waveletDeComposition);
  }

  private static final void reverse(double[] array) {
    int i = 0;
    int j = array.length - 1;
    
    while (i < j) {
      double tmp = array[i];
      array[i] = array[j];
      array[j] = tmp;
      i++;
      j--;
    }
  }

  public int getTransformWavelength() {
    return transformWavelength;
  }

  public int getMotherWavelength() {
    return waveletReConstruction.length;
  }

  public double[] getScalingDeComposition() {
    return scalingDeComposition;
  }

  public double[] getWaveletDeComposition() {
    return waveletDeComposition;
  }

  public double[] getScalingReConstruction() {
    return scalingReConstruction;
  }

  public double[] getWaveletReConstruction() {
    return waveletReConstruction;
  }
}

