/*
 * Decompiled with CFR 0.152.
 */
package io.warp10.warpfleet.utils;

import io.warp10.warpfleet.utils.Logger;
import io.warp10.warpfleet.utils.PackageInfo;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kong.unirest.GetRequest;
import kong.unirest.HttpResponse;
import kong.unirest.JsonNode;
import kong.unirest.Unirest;
import kong.unirest.json.JSONArray;
import kong.unirest.json.JSONObject;
import org.apache.commons.io.FileUtils;

public class Helper {
    public static final String WF_URL = "https://warpfleet.senx.io";

    Helper() {
    }

    public static JSONArray getGroups() {
        return ((JsonNode)((GetRequest)Unirest.get((String)"https://warpfleet.senx.io/api/").header("accept", "application/json")).asJson().ifFailure(Helper::processHTTPError).getBody()).getObject().getJSONArray("children");
    }

    public static JSONObject getVersions(String group, String artifact) {
        return ((JsonNode)((GetRequest)((GetRequest)((GetRequest)Unirest.get((String)"https://warpfleet.senx.io/api/{group}/{artifact}").routeParam("group", group)).routeParam("artifact", artifact)).header("accept", "application/json")).asJson().ifFailure(Helper::processHTTPError).getBody()).getObject();
    }

    public static JSONObject getArtifactInfo(PackageInfo pi) {
        return Helper.getArtifactInfo(pi.getGroup(), pi.getName(), pi.getVersion());
    }

    public static JSONObject getArtifactInfo(String group, String artifact, String version) {
        return ((JsonNode)((GetRequest)((GetRequest)((GetRequest)((GetRequest)Unirest.get((String)"https://warpfleet.senx.io/api/{group}/{artifact}/{version}").routeParam("group", group)).routeParam("artifact", artifact)).routeParam("version", version)).header("accept", "application/json")).asJson().ifFailure(Helper::processHTTPError).getBody()).getObject();
    }

    public static JSONArray getArtifacts(String group) {
        return ((JsonNode)((GetRequest)((GetRequest)Unirest.get((String)"https://warpfleet.senx.io/api/{group}").routeParam("group", group)).header("accept", "application/json")).asJson().ifFailure(Helper::processHTTPError).getBody()).getObject().getJSONArray("children");
    }

    public static JSONObject getLatest(String group, String artifact) {
        return ((JsonNode)((GetRequest)((GetRequest)((GetRequest)Unirest.get((String)"https://warpfleet.senx.io/api/{group}/{artifact}").routeParam("group", group)).routeParam("artifact", artifact)).header("accept", "application/json")).asJson().ifFailure(Helper::processHTTPError).getBody()).getObject();
    }

    public static void execCmd(File workDir, String[] cmd) throws IOException, InterruptedException {
        Helper.execCmd(workDir, Arrays.asList(cmd));
    }

    public static void execCmd(File workDir, String cmd) throws IOException, InterruptedException {
        System.out.println(cmd);
        Helper.execCmd(workDir, cmd.split(" "));
    }

    public static void execCmd(File workDir, List<String> cmd) throws IOException, InterruptedException {
        Process process;
        ProcessBuilder p = new ProcessBuilder(cmd);
        if (null != workDir) {
            p.directory(workDir);
        }
        p.redirectInput(ProcessBuilder.Redirect.PIPE);
        p.redirectOutput(ProcessBuilder.Redirect.PIPE);
        p.redirectError(ProcessBuilder.Redirect.PIPE);
        try {
            process = p.start();
        }
        catch (IOException ex) {
            throw new RuntimeException("Failed to run command: " + cmd.get(0), ex);
        }
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(process.getInputStream()));){
            String line;
            while ((line = reader.readLine()) != null) {
                Logger.messageInfo(line);
            }
        }
        reader = new BufferedReader(new InputStreamReader(process.getErrorStream()));
        var5_6 = null;
        try {
            while ((line = reader.readLine()) != null) {
                Logger.messageError("\u001b[31m" + line + "\u001b[0m");
            }
        }
        catch (Throwable throwable) {
            var5_6 = throwable;
            throw throwable;
        }
        finally {
            if (reader != null) {
                if (var5_6 != null) {
                    try {
                        reader.close();
                    }
                    catch (Throwable throwable) {
                        var5_6.addSuppressed(throwable);
                    }
                } else {
                    reader.close();
                }
            }
        }
        process.waitFor();
        if (process.exitValue() != 0) {
            throw new RuntimeException("Failed to run command: " + cmd.get(0));
        }
    }

    public static void processHTTPError(HttpResponse<?> response) {
        Logger.messageError("Oh No! Status: " + response.getStatus());
        Logger.messageError(response.getStatusText());
        response.getHeaders().all().stream().filter(h -> h.getName().contains("X-Warp10")).forEach(h -> Logger.messageError(h.getName() + ": " + h.getValue()));
        response.getParsingError().ifPresent(e -> {
            Logger.messageError("Parsing Exception: " + e.getMessage());
            Logger.messageError("Original body: " + e.getOriginalBody());
        });
        throw new RuntimeException("An HTTP error occurs: " + response.getStatus() + " " + response.getStatusText());
    }

    public static String path(String ... dirs) {
        return String.join((CharSequence)File.separator, dirs);
    }

    public static File filePath(String ... dirs) {
        return new File(Helper.path(dirs));
    }

    public static void getMacro(String group, String artifact, String version, JSONObject macro, String warp10Dir) throws IOException {
        File dest = Helper.filePath(warp10Dir, "lib", macro.getString("path"));
        if (!dest.getParentFile().exists() && !dest.getParentFile().mkdirs()) {
            throw new IOException("Cannot write " + dest.getAbsolutePath());
        }
        String macroContent = (String)((GetRequest)((GetRequest)((GetRequest)((GetRequest)Unirest.get((String)"https://warpfleet.senx.io/api/{group}/{artifact}/{version}/{macro}").routeParam("group", group)).routeParam("artifact", artifact)).routeParam("version", version)).routeParam("macro", macro.getString("path"))).asString().ifFailure(Helper::processHTTPError).getBody();
        FileUtils.write((File)dest, (CharSequence)macroContent, (Charset)StandardCharsets.UTF_8);
    }

    public static String getFileAsString(String fileName, Class<?> clazz) throws IOException, IllegalArgumentException {
        InputStream is = Helper.getFileAsIOStream(fileName, clazz);
        StringBuilder sb = new StringBuilder();
        try (InputStreamReader isr = new InputStreamReader(is, StandardCharsets.UTF_8);
             BufferedReader br = new BufferedReader(isr);){
            String line;
            while ((line = br.readLine()) != null) {
                sb.append(line).append('\n');
            }
            is.close();
        }
        return sb.toString();
    }

    public static InputStream getFileAsIOStream(String fileName, Class<?> clazz) {
        InputStream ioStream = clazz.getClassLoader().getResourceAsStream(fileName);
        if (ioStream == null) {
            throw new IllegalArgumentException(fileName + " is not found");
        }
        return ioStream;
    }

    public static Map<String, String> getParamsMap(String ... data) {
        HashMap<String, String> result = new HashMap<String, String>();
        if (data.length % 2 != 0) {
            throw new IllegalArgumentException("Odd number of arguments");
        }
        String key = null;
        int step = -1;
        block4: for (String value : data) {
            switch (++step % 2) {
                case 0: {
                    if (value == null) {
                        throw new IllegalArgumentException("Null key value");
                    }
                    key = value;
                    continue block4;
                }
                case 1: {
                    result.put(key, value);
                }
            }
        }
        return result;
    }

    public static void signArtefact(File f, String gpgKeyId, String gpgArg) throws IOException, InterruptedException {
        Logger.messageInfo("Signing artifact");
        ArrayList<String> gpgArgs = new ArrayList<String>();
        gpgArgs.add("gpg");
        gpgArgs.add("--sign");
        gpgArgs.add("--yes");
        if (null != gpgArg) {
            Collections.addAll(gpgArgs, gpgArg.split(" "));
        }
        if (null != gpgKeyId) {
            gpgArgs.add("--default-key");
            gpgArgs.add(gpgKeyId);
        }
        gpgArgs.add(f.getCanonicalPath());
        gpgArgs = gpgArgs.stream().map(String::trim).collect(Collectors.toList());
        Helper.execCmd(null, gpgArgs);
        FileUtils.delete((File)f);
        Logger.messageSusccess("Artifact signed");
    }
}

