/*
 * Decompiled with CFR 0.152.
 */
package io.warp10.warpfleet.doc.generators;

import com.openhtmltopdf.util.XRLog;
import com.vladsch.flexmark.pdf.converter.PdfConverterExtension;
import com.vladsch.flexmark.util.ast.Node;
import com.vladsch.flexmark.util.data.DataHolder;
import io.warp10.warpfleet.doc.generators.HTMLGenerator;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import kong.unirest.json.JSONObject;

public class PDFGenerator
extends HTMLGenerator {
    public PDFGenerator() {
        XRLog.listRegisteredLoggers().forEach(logger -> XRLog.setLevel((String)logger, (Level)Level.OFF));
    }

    @Override
    public List<JSONObject> output(File dest, List<JSONObject> doc) throws IOException {
        ArrayList<JSONObject> index = new ArrayList<JSONObject>();
        ArrayList<String> pages = new ArrayList<String>();
        if (!dest.exists() && !dest.mkdirs()) {
            throw new IOException("Cannot create " + dest.getCanonicalPath());
        }
        for (JSONObject d : doc) {
            String title;
            String fName = d.getString("file").replace(".mc2", ".pdf");
            JSONObject docObj = d.optJSONObject("doc");
            if (null == docObj) {
                docObj = new JSONObject();
            }
            if (!(title = d.optString(d.getString("name"), docObj.optString("name", ""))).startsWith("@")) {
                title = "@" + title;
            }
            index.add(new JSONObject().put("f", fName).put("title", title));
            pages.add(this.renderer.render((Node)this.parser.parse(this.getMarkdown(docObj, title))));
        }
        PdfConverterExtension.exportToPdf((String)(dest.getCanonicalPath() + File.separator + "index.pdf"), (String)this.wrapHTML(String.join((CharSequence)"<div class=\"pagebreak\"></div>", pages), "Index"), (String)"", (DataHolder)OPTIONS);
        return index;
    }
}

