/*
 * Decompiled with CFR 0.152.
 */
package io.warp10.warpfleet.doc.generators;

import io.warp10.warpfleet.doc.generators.AbstractGenerator;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import kong.unirest.json.JSONArray;
import kong.unirest.json.JSONObject;
import org.apache.commons.io.FileUtils;

public class MarkdownGenerator
extends AbstractGenerator {
    @Override
    public List<JSONObject> output(File dest, List<JSONObject> doc) throws IOException {
        ArrayList<JSONObject> index = new ArrayList<JSONObject>();
        if (!dest.exists() && !dest.mkdirs()) {
            throw new IOException("Cannot create " + dest.getCanonicalPath());
        }
        for (JSONObject d : doc) {
            String title;
            File folder = new File(dest.getCanonicalPath() + File.separator + d.getString("file")).getParentFile();
            if (!folder.exists() && !folder.mkdirs()) {
                throw new IOException("Cannot create " + folder.getCanonicalPath());
            }
            String fName = d.getString("file").replace(".mc2", ".md");
            File f = new File(dest.getCanonicalPath() + File.separator + fName);
            JSONObject docObj = d.optJSONObject("doc");
            if (null == docObj) {
                docObj = new JSONObject();
            }
            if (!(title = d.optString(d.getString("name"), docObj.optString("name", ""))).startsWith("@")) {
                title = "@" + title;
            }
            index.add(new JSONObject().put("f", fName).put("title", title));
            FileUtils.write((File)f, (CharSequence)this.getMarkdown(docObj, title), (Charset)StandardCharsets.UTF_8);
        }
        String toc = index.stream().map(i -> {
            try {
                return this.generateMDIndex((JSONObject)i, dest.getCanonicalPath());
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }).collect(Collectors.joining("\n"));
        FileUtils.write((File)new File(dest.getCanonicalPath() + File.separator + "index.md"), (CharSequence)toc, (Charset)StandardCharsets.UTF_8);
        return index;
    }

    private String generateMDIndex(JSONObject i, String dest) {
        return "- [" + i.optString("title", "") + "](./" + i.optString("f", "").replace(dest, "") + ")\n";
    }

    private String generateMarkdownSamples(JSONObject doc) {
        StringBuilder md = new StringBuilder().append("## Samples\n\n");
        JSONArray examples = doc.optJSONArray("examples");
        if (null == examples) {
            examples = new JSONArray();
        }
        examples.forEach(e -> md.append("````warpscript\n").append(e).append("\n````\n\n"));
        return md.toString();
    }

    private String formatParam(JSONObject s) {
        return AbstractGenerator.sanitize(s.getString("name")) + "&lt;" + AbstractGenerator.sanitize(s.getString("type")) + "&gt;";
    }

    private String generateMarkdownSignatures(JSONObject sig, String fnName) {
        JSONObject input = sig.getJSONObject("input");
        JSONObject output = sig.getJSONObject("output");
        JSONArray signatures = sig.optJSONArray("signatures");
        if (null == signatures) {
            signatures = new JSONArray();
        }
        StringBuilder md = new StringBuilder().append("## Signatures\n\n");
        signatures.forEach(sign -> {
            JSONObject signature = (JSONObject)sign;
            md.append("- ");
            signature.getJSONArray("in").forEach(in -> {
                List sigItems;
                JSONObject item = (JSONObject)in;
                if (item.getBoolean("isArray") && !item.getBoolean("isObject")) {
                    md.append("[ ");
                    sigItems = item.getJSONArray("sigItems").toList();
                    Collections.reverse(sigItems);
                    sigItems.forEach(s -> md.append(this.formatParam((JSONObject)s)).append(" "));
                    md.append("] ");
                }
                if (!item.getBoolean("isArray") && item.getBoolean("isObject")) {
                    md.append("{ ");
                    sigItems = item.getJSONArray("sigItems").toList();
                    Collections.reverse(sigItems);
                    sigItems.forEach(s -> md.append(this.formatParam((JSONObject)s)).append(" "));
                    md.append("} ");
                }
                if (!item.getBoolean("isArray") && !item.getBoolean("isObject")) {
                    md.append(this.formatParam(item.optJSONObject("sigItems"))).append(" ");
                }
            });
            md.append("`").append(fnName).append("` ");
            signature.getJSONArray("out").forEach(out -> {
                List sigItems;
                JSONObject item = (JSONObject)out;
                if (item.getBoolean("isArray") && !item.getBoolean("isObject")) {
                    md.append("[ ");
                    sigItems = item.getJSONArray("sigItems").toList();
                    Collections.reverse(sigItems);
                    sigItems.forEach(s -> md.append(this.formatParam((JSONObject)s)).append(" "));
                    md.append("] ");
                }
                if (!item.getBoolean("isArray") && item.getBoolean("isObject")) {
                    md.append("{ ");
                    sigItems = item.getJSONArray("sigItems").toList();
                    Collections.reverse(sigItems);
                    sigItems.forEach(s -> md.append(this.formatParam((JSONObject)s)).append(" "));
                    md.append("} ");
                }
                if (!item.getBoolean("isArray") && !item.getBoolean("isObject")) {
                    md.append(this.formatParam(item.optJSONObject("sigItems"))).append(" ");
                }
            });
            md.append('\n');
        });
        md.append("\n\n| Name | Type | Description |\n| --- | --- | --- |\n");
        input.keySet().forEach(k -> {
            JSONObject it = input.getJSONObject(k);
            md.append("| ").append(it.getString("name")).append(" | ").append(it.getString("type")).append(" | ").append(it.optString("desc", "").replaceAll("\n", "<br />")).append(" |\n");
        });
        output.keySet().forEach(k -> {
            JSONObject it = output.getJSONObject(k);
            md.append("| ").append(it.getString("name")).append(" | ").append(it.getString("type")).append(" | ").append(it.optString("desc", "").replaceAll("\n", "<br />")).append(" |\n");
        });
        md.append('\n');
        return md.toString();
    }

    protected String getMarkdown(JSONObject docObj, String title) {
        return "# `" + title + "`\n\n" + docObj.optString("desc", "") + "\n\n" + this.generateRelated(docObj.optJSONArray("related")) + this.generateMarkdownSignatures(this.generateSignature(docObj), title) + this.generateMarkdownSamples(docObj);
    }

    private String generateRelated(JSONArray related) {
        if (null == related) {
            return "";
        }
        StringBuilder md = new StringBuilder().append("## See also\n\n");
        related.forEach(r -> {
            if (r instanceof String) {
                r = new JSONObject().put("b64", r).put("label", r);
            }
            JSONObject rel = (JSONObject)r;
            md.append("- [./").append(rel.optString("b64", "")).append(".md](").append(rel.optString("label", "")).append(")\n");
        });
        return md.append('\n').toString();
    }
}

