/*
 * Decompiled with CFR 0.152.
 */
package io.warp10.warpfleet.doc.generators;

import io.warp10.warpfleet.doc.generators.AbstractGenerator;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import kong.unirest.json.JSONArray;
import kong.unirest.json.JSONObject;
import org.apache.commons.io.FileUtils;

public class JSONGenerator
extends AbstractGenerator {
    @Override
    public List<JSONObject> output(File dest, List<JSONObject> doc) throws IOException {
        ArrayList<JSONObject> index = new ArrayList<JSONObject>();
        if (!dest.exists() && !dest.mkdirs()) {
            throw new IOException("Cannot create " + dest.getCanonicalPath());
        }
        for (JSONObject d : doc) {
            File folder = new File(dest.getCanonicalPath() + File.separator + d.getString("file")).getParentFile();
            if (!folder.exists() && !folder.mkdirs()) {
                throw new IOException("Cannot create " + folder.getCanonicalPath());
            }
            String fName = d.getString("file").replace(".mc2", ".json");
            File f = new File(dest.getCanonicalPath() + File.separator + fName);
            String title = d.optString(d.getString("name"), "");
            JSONObject docObj = d.optJSONObject("doc");
            if (null != docObj) {
                title = docObj.optString("name", "");
            }
            if (!title.startsWith("@")) {
                title = "@" + title;
            }
            index.add(new JSONObject().put("f", fName).put("title", title));
            FileUtils.write((File)f, (CharSequence)d.toString(2), (Charset)StandardCharsets.UTF_8);
        }
        JSONArray toc = new JSONArray();
        for (JSONObject i : index) {
            toc.put(new JSONObject().put("link", i.optString("f", "").replace(dest.getCanonicalPath(), "")).put("title", i.optString("title", "")));
        }
        FileUtils.write((File)new File(dest.getCanonicalPath() + File.separator + "index.json"), (CharSequence)toc.toString(2), (Charset)StandardCharsets.UTF_8);
        return index;
    }
}

