/*
 * Decompiled with CFR 0.152.
 */
package io.warp10.warpfleet.doc.generators;

import com.vladsch.flexmark.ext.attributes.AttributesExtension;
import com.vladsch.flexmark.ext.autolink.AutolinkExtension;
import com.vladsch.flexmark.ext.gitlab.GitLabExtension;
import com.vladsch.flexmark.ext.tables.TablesExtension;
import com.vladsch.flexmark.ext.toc.TocExtension;
import com.vladsch.flexmark.ext.typographic.TypographicExtension;
import com.vladsch.flexmark.ext.wikilink.WikiLinkExtension;
import com.vladsch.flexmark.html.HtmlRenderer;
import com.vladsch.flexmark.parser.Parser;
import com.vladsch.flexmark.util.ast.Node;
import com.vladsch.flexmark.util.data.DataHolder;
import com.vladsch.flexmark.util.data.MutableDataSet;
import io.warp10.warpfleet.doc.generators.MarkdownGenerator;
import io.warp10.warpfleet.utils.Helper;
import io.warp10.warpfleet.utils.Logger;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import kong.unirest.json.JSONObject;
import org.apache.commons.io.FileUtils;

public class HTMLGenerator
extends MarkdownGenerator {
    protected static final DataHolder OPTIONS = new MutableDataSet().set(HtmlRenderer.INDENT_SIZE, (Object)2).set(Parser.HTML_BLOCK_DEEP_PARSER, (Object)true).set(Parser.HTML_BLOCK_DEEP_PARSE_BLANK_LINE_INTERRUPTS, (Object)false).set(Parser.HTML_BLOCK_DEEP_PARSE_FIRST_OPEN_TAG_ON_ONE_LINE, (Object)true).set(Parser.HTML_BLOCK_DEEP_PARSE_BLANK_LINE_INTERRUPTS_PARTIAL_TAG, (Object)false).set(TablesExtension.COLUMN_SPANS, (Object)false).set(TablesExtension.APPEND_MISSING_COLUMNS, (Object)true).set(TablesExtension.DISCARD_EXTRA_COLUMNS, (Object)true).set(TablesExtension.HEADER_SEPARATOR_COLUMN_MATCH, (Object)true).set(WikiLinkExtension.IMAGE_LINKS, (Object)true).set(TocExtension.LIST_CLASS, (Object)"toc").set(Parser.EXTENSIONS, Arrays.asList(TablesExtension.create(), AttributesExtension.create(), AutolinkExtension.create(), GitLabExtension.create(), TypographicExtension.create()));
    protected final Parser parser = Parser.builder((DataHolder)OPTIONS).build();
    protected final HtmlRenderer renderer = HtmlRenderer.builder((DataHolder)OPTIONS).build();

    @Override
    public List<JSONObject> output(File dest, List<JSONObject> doc) throws IOException {
        ArrayList<JSONObject> index = new ArrayList<JSONObject>();
        if (!dest.exists() && !dest.mkdirs()) {
            throw new IOException("Cannot create " + dest.getCanonicalPath());
        }
        for (JSONObject d : doc) {
            String title;
            File folder = new File(dest.getCanonicalPath() + File.separator + d.getString("file")).getParentFile();
            if (!folder.exists() && !folder.mkdirs()) {
                throw new IOException("Cannot create " + folder.getCanonicalPath());
            }
            String fName = d.getString("file").replace(".mc2", ".html");
            File f = new File(dest.getCanonicalPath() + File.separator + fName);
            JSONObject docObj = d.optJSONObject("doc");
            if (null == docObj) {
                docObj = new JSONObject();
            }
            if (!(title = d.optString(d.getString("name"), docObj.optString("name", ""))).startsWith("@")) {
                title = "@" + title;
            }
            index.add(new JSONObject().put("f", fName).put("title", title));
            FileUtils.write((File)f, (CharSequence)this.wrapHTML(this.renderer.render((Node)this.parser.parse(this.getMarkdown(docObj, title))), title), (Charset)StandardCharsets.UTF_8);
        }
        String toc = index.stream().map(i -> {
            try {
                return this.generateHTMLIndex((JSONObject)i, dest.getCanonicalPath());
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }).collect(Collectors.joining("\n"));
        FileUtils.write((File)new File(dest.getCanonicalPath() + File.separator + "index.html"), (CharSequence)this.wrapHTML("<ul>" + toc + "</ul>", "Index"), (Charset)StandardCharsets.UTF_8);
        return index;
    }

    protected String generateHTMLIndex(JSONObject i, String dest) {
        return "<li><a href=\"./" + i.optString("f", "").replace(dest, "") + "\">" + i.optString("title", "") + "</a></li>";
    }

    protected String wrapHTML(String html, String title) {
        String tpl;
        try {
            tpl = Helper.getFileAsString("html.tpl", this.getClass());
        }
        catch (IOException | IllegalArgumentException e) {
            Logger.messageError("Error, cannot read html.tpl ");
            throw new RuntimeException(e);
        }
        return tpl.replaceAll(Pattern.quote("{{title}}"), Matcher.quoteReplacement(title)).replaceAll(Pattern.quote("{{content}}"), Matcher.quoteReplacement(html));
    }
}

