/*
 * Decompiled with CFR 0.152.
 */
package io.warp10.warpfleet.actions;

import io.warp10.warpfleet.utils.Constants;
import io.warp10.warpfleet.utils.Helper;
import io.warp10.warpfleet.utils.Logger;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import kong.unirest.JsonNode;
import kong.unirest.Unirest;
import kong.unirest.json.JSONObject;
import org.apache.commons.io.FileUtils;
import org.gradle.api.DefaultTask;
import org.gradle.api.internal.tasks.userinput.UserInputHandler;
import org.gradle.api.provider.Property;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.Optional;
import org.gradle.api.tasks.TaskAction;
import org.gradle.api.tasks.options.Option;

public abstract class UnPublish
extends DefaultTask {
    UserInputHandler userInput = (UserInputHandler)this.getServices().get(UserInputHandler.class);

    @Input
    @Optional
    @Option(option="repoUrl", description="Maven repository URL")
    public abstract Property<String> getWFRepoUrl();

    @Input
    @Optional
    @Option(option="vers", description="Artifact version to unpublish")
    public abstract Property<String> getWFVersion();

    @Input
    @Optional
    @Option(option="gpgKeyId", description="GPG Key Id")
    public abstract Property<String> getWFGpgKeyId();

    @Input
    @Optional
    @Option(option="gpgArg", description="GPG gpgArg")
    public abstract Property<String> getWFGpgArg();

    @Input
    @Option(option="wfJson", description="Path to wf.json")
    public abstract Property<String> getWFJson();

    @Input
    @Optional
    @Option(option="force", description="Force unpublish")
    public abstract Property<Boolean> getWFForce();

    public UnPublish() {
        this.setDescription("Unpublishes a plugin, macro or extension against WarpFleet");
        this.setGroup(Constants.GROUP);
    }

    @TaskAction
    public void unPublishArtifact() throws IOException, InterruptedException {
        File wfJson = new File((String)this.getWFJson().get());
        if (!wfJson.exists()) {
            throw new RuntimeException("Cannot reach wf.json");
        }
        JSONObject conf = new JSONObject(FileUtils.readFileToString((File)wfJson, (Charset)StandardCharsets.UTF_8));
        conf.put("ts", System.currentTimeMillis());
        if (null != this.getWFRepoUrl().getOrNull()) {
            conf.put("repoUrl", (String)this.getWFRepoUrl().get());
        }
        if (null != this.getWFVersion().getOrNull()) {
            conf.put("version", (String)this.getWFVersion().get());
        }
        if (((Boolean)this.getWFForce().getOrElse((Object)false)).booleanValue() || this.userInput.askYesNoQuestion("Are you sure to unpublish " + conf.getString("group") + ":" + conf.getString("artifact") + ":" + conf.getString("version") + "?", false)) {
            Logger.messageInfo("About to unpublish: " + conf.getString("group") + ":" + conf.getString("artifact") + ":" + conf.getString("version"));
            File tmpConf = new File(wfJson.getCanonicalPath() + ".tmp");
            FileUtils.write((File)tmpConf, (CharSequence)conf.toString(2), (Charset)StandardCharsets.UTF_8);
            Helper.signArtefact(tmpConf, (String)this.getWFGpgKeyId().getOrNull(), (String)this.getWFGpgArg().getOrNull());
            Logger.messageInfo("Unpublishing");
            JSONObject result = ((JsonNode)Unirest.post((String)"https://warpfleet.senx.io/data/unpublish").field("sig", new File(tmpConf.getCanonicalPath() + ".gpg")).field("meta", conf.toString(2)).asJson().ifFailure(Helper::processHTTPError).getBody()).getObject();
            FileUtils.delete((File)new File(tmpConf.getCanonicalPath() + ".gpg"));
            if (!result.optBoolean("status", false)) {
                Logger.messageError("An error Occurs");
                if (result.has("message")) {
                    Logger.messageError(result.getString("message"));
                    throw new RuntimeException(result.getString("message"));
                }
            } else {
                Logger.messageSusccess(conf.getString("group") + ":" + conf.getString("artifact") + ":" + conf.getString("version") + " Unpublished");
            }
        }
    }
}

