/*
 * Decompiled with CFR 0.152.
 */
package io.warp10.warpfleet.actions;

import io.warp10.warpfleet.utils.Constants;
import io.warp10.warpfleet.utils.Helper;
import io.warp10.warpfleet.utils.Logger;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import kong.unirest.JsonNode;
import kong.unirest.Unirest;
import kong.unirest.json.JSONObject;
import org.apache.commons.io.FileUtils;
import org.gradle.api.DefaultTask;
import org.gradle.api.provider.Property;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.Optional;
import org.gradle.api.tasks.TaskAction;
import org.gradle.api.tasks.options.Option;

public abstract class Publish
extends DefaultTask {
    @Input
    @Optional
    @Option(option="repoUrl", description="Maven repository URL")
    public abstract Property<String> getWFRepoUrl();

    @Input
    @Optional
    @Option(option="vers", description="Artifact version to publish")
    public abstract Property<String> getWfVersion();

    @Input
    @Optional
    @Option(option="gpgKeyId", description="GPG Key Id")
    public abstract Property<String> getWFGpgKeyId();

    @Input
    @Optional
    @Option(option="gpgArg", description="GPG gpgArg")
    public abstract Property<String> getWFGpgArg();

    @Input
    @Option(option="wfJson", description="Path to wf.json")
    public abstract Property<String> getWFJson();

    public Publish() {
        this.setDescription("Publishes a plugin, macro or extension against WarpFleet");
        this.setGroup(Constants.GROUP);
    }

    @TaskAction
    public void publishArtifact() throws IOException, InterruptedException {
        File wfJson = new File((String)this.getWFJson().get());
        if (!wfJson.exists()) {
            throw new RuntimeException("Cannot reach wf.json");
        }
        JSONObject conf = new JSONObject(FileUtils.readFileToString((File)wfJson, (Charset)StandardCharsets.UTF_8));
        conf.put("ts", System.currentTimeMillis());
        if (null != this.getWFRepoUrl().getOrNull()) {
            conf.put("repoUrl", (String)this.getWFRepoUrl().get());
        }
        if (null != this.getWfVersion().getOrNull()) {
            conf.put("version", (String)this.getWfVersion().get());
        }
        Logger.messageInfo("About to publish: " + conf.getString("group") + ":" + conf.getString("artifact") + ":" + conf.getString("version"));
        ArrayList<String> missingFiles = new ArrayList<String>();
        if (!new File(wfJson.getParentFile().getCanonicalPath() + File.separator + "README.md").exists()) {
            missingFiles.add("README.md");
        }
        if (!missingFiles.isEmpty()) {
            Logger.messageError("Some mandatory files ar missing: " + String.join((CharSequence)", ", missingFiles));
            throw new RuntimeException("Missing mandatory files");
        }
        File tmpConf = new File(wfJson.getCanonicalPath() + ".tmp");
        FileUtils.write((File)tmpConf, (CharSequence)conf.toString(2), (Charset)StandardCharsets.UTF_8);
        Helper.signArtefact(tmpConf, (String)this.getWFGpgKeyId().getOrNull(), (String)this.getWFGpgArg().getOrNull());
        Logger.messageInfo("Publishing");
        JSONObject result = ((JsonNode)Unirest.post((String)"https://warpfleet.senx.io/data/publish").field("sig", new File(tmpConf.getCanonicalPath() + ".gpg")).field("meta", conf.toString(2)).asJson().ifFailure(Helper::processHTTPError).getBody()).getObject();
        FileUtils.delete((File)new File(tmpConf.getCanonicalPath() + ".gpg"));
        if (!result.optBoolean("status", false)) {
            Logger.messageError("An error Occurs");
            if (result.has("message")) {
                Logger.messageError(result.getString("message"));
                throw new RuntimeException(result.getString("message"));
            }
        } else {
            Logger.messageSusccess(conf.getString("group") + ":" + conf.getString("artifact") + ":" + conf.getString("version") + " Published");
        }
    }
}

