/*
 * Decompiled with CFR 0.152.
 */
package io.warp10.warpfleet.actions;

import io.warp10.warpfleet.utils.Constants;
import io.warp10.warpfleet.utils.Helper;
import io.warp10.warpfleet.utils.Logger;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import kong.unirest.json.JSONArray;
import kong.unirest.json.JSONObject;
import org.apache.commons.io.FileUtils;
import org.gradle.api.DefaultTask;
import org.gradle.api.provider.Property;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.Optional;
import org.gradle.api.tasks.TaskAction;
import org.gradle.api.tasks.options.Option;

public abstract class InitModule
extends DefaultTask {
    @Input
    @Option(option="group", description="Artifact's group, ie: io.warp10")
    public abstract Property<String> getWfGroup();

    @Input
    @Option(option="artifact", description="Artifact's name, ie: warp10-plugin-mqtt")
    public abstract Property<String> getWfArtifact();

    @Input
    @Optional
    @Option(option="vers", description="Artifact's version, ie: 0.0.3")
    public abstract Property<String> getWfVersion();

    @Input
    @Option(option="type", description="Artifact's type [ext|plugin|macro]")
    public abstract Property<String> getWfType();

    @Input
    @Optional
    @Option(option="dest", description="Project parent's folder")
    public abstract Property<String> getWfDest();

    public InitModule() {
        this.setDescription("Init module dev");
        this.setGroup(Constants.GROUP);
    }

    @TaskAction
    public void initModule() throws IOException, InterruptedException {
        Logger.messageInfo("About to generate " + (String)this.getWfGroup().get() + ":" + (String)this.getWfArtifact().get() + ":" + (String)this.getWfVersion().getOrElse((Object)"0.0.1"));
        Logger.messageInfo("Retrieving starter kit");
        File dest = Helper.filePath((String)this.getWfDest().getOrElse((Object)"."), (String)this.getWfArtifact().get());
        File tmp = new File(System.getProperty("java.io.tmpdir") + File.separator + ".git");
        if (tmp.exists()) {
            FileUtils.deleteDirectory((File)tmp);
        }
        Helper.execCmd(dest.getParentFile(), "git clone -q --depth=1 --separate-git-dir=" + tmp.getAbsolutePath() + " https://github.com/senx/warp10-module-template.git " + dest.getCanonicalPath());
        FileUtils.delete((File)Helper.filePath(dest.getAbsolutePath() + File.separator + ".git"));
        Logger.messageInfo("Generating artifacts");
        String cmd = "./gradlew -q bootstrap -Pg=" + (String)this.getWfGroup().get() + " -Pa=" + (String)this.getWfArtifact().get() + " -Pv=" + (String)this.getWfVersion().getOrElse((Object)"0.0.1") + " -Pt=" + (String)this.getWfType().get() + " -Pd=\"\"";
        Helper.execCmd(dest, cmd);
        FileUtils.write((File)Helper.filePath(dest.getAbsolutePath(), "README.md"), (CharSequence)("# " + (String)this.getWfGroup().get() + ":" + (String)this.getWfArtifact().get()), (Charset)StandardCharsets.UTF_8);
        JSONObject wf = new JSONObject().put("group", (String)this.getWfGroup().get()).put("artifact", (String)this.getWfArtifact().get()).put("type", (String)this.getWfType().get()).put("classifier", "").put("version", (String)this.getWfVersion().getOrElse((Object)"0.0.1")).put("description", "").put("license", "").put("git", "").put("author", "").put("email", "").put("repoUrl", "").put("tags", new JSONArray()).put("conf", new JSONArray()).put("macros", new JSONArray()).put("dependencies", new JSONArray());
        FileUtils.write((File)Helper.filePath(dest.getAbsolutePath(), "wf.json"), (CharSequence)wf.toString(2), (Charset)StandardCharsets.UTF_8);
        Logger.messageSusccess("Artifact generated, happy coding");
    }
}

