/*
 * Decompiled with CFR 0.152.
 */
package io.warp10.warpfleet.actions;

import io.warp10.warpfleet.doc.generators.AbstractGenerator;
import io.warp10.warpfleet.doc.generators.HTMLGenerator;
import io.warp10.warpfleet.doc.generators.JSONGenerator;
import io.warp10.warpfleet.doc.generators.MarkdownGenerator;
import io.warp10.warpfleet.doc.generators.PDFGenerator;
import io.warp10.warpfleet.utils.Constants;
import io.warp10.warpfleet.utils.Helper;
import io.warp10.warpfleet.utils.Logger;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kong.unirest.HttpRequestWithBody;
import kong.unirest.Unirest;
import kong.unirest.json.JSONArray;
import kong.unirest.json.JSONObject;
import org.apache.commons.io.FileUtils;
import org.gradle.api.DefaultTask;
import org.gradle.api.provider.Property;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.Optional;
import org.gradle.api.tasks.TaskAction;
import org.gradle.api.tasks.options.Option;

public abstract class GenerateDocumentation
extends DefaultTask {
    @Input
    @Option(option="url", description="Warp 10 url, e.g. http://localhost:8080/api/v0")
    public abstract Property<String> getWfUrl();

    @Input
    @Optional
    @Option(option="source", description="Macros source directory, e.g. /path/to/warp10/macros")
    public abstract Property<String> getWfSource();

    @Input
    @Option(option="dest", description="Output directory, e.g. ./resArr")
    public abstract Property<String> getWfDest();

    @Input
    @Optional
    @Option(option="format", description="Output format (json, html, markdown)")
    public abstract Property<String> getWfFormat();

    @Input
    @Optional
    @Option(option="macroDir", description="Macro sub directory")
    public abstract Property<String> getWfMacroDir();

    public GenerateDocumentation() {
        this.setDescription("Generates documentation files against a Warp 10 instance thanks to the INFOMODE.");
        this.setGroup(Constants.GROUP);
    }

    @TaskAction
    public void generateDocumentation() throws IOException {
        List<File> filestoProcess = this.getFiles(new File((String)this.getWfSource().getOrElse((Object)".")));
        ArrayList fileList = new ArrayList();
        ArrayList<JSONObject> fileListToProcess = new ArrayList<JSONObject>();
        filestoProcess.forEach(f -> fileList.add(new JSONObject().put("fileObj", f).put("file", f.getAbsolutePath().replace(new File((String)this.getWfSource().getOrElse((Object)".")).getAbsolutePath(), "").substring(1)).put("dir", this.getWfSource())));
        fileList.forEach(f -> {
            try {
                String tpl;
                String macroWS = FileUtils.readFileToString((File)new File(f.getString("fileObj")), (Charset)StandardCharsets.UTF_8);
                String macro = "@" + f.getString("file").replace(".mc2", "");
                try {
                    tpl = Helper.getFileAsString("infomode.tpl", ((Object)((Object)this)).getClass());
                }
                catch (IOException | IllegalArgumentException e) {
                    Logger.messageError("Error, cannot read infomode.tpl ");
                    throw new RuntimeException(e);
                }
                tpl = tpl.replace("{{macro}}", this.wrapMacro(macroWS));
                Logger.messageInfo("Generating documentation for " + macro);
                String res = (String)((HttpRequestWithBody)Unirest.post((String)((String)this.getWfUrl().getOrElse((Object)"http://localhost:8080/api/v0/exec"))).header("Content-Type", "text/plain;charset=utf-8")).body(tpl).asString().ifFailure(Helper::processHTTPError).getBody();
                JSONArray resArr = new JSONArray(res);
                JSONObject doc = resArr.length() > 0 ? resArr.getJSONObject(0) : new JSONObject();
                f.put("doc", doc).put("name", macro);
                fileListToProcess.add((JSONObject)f);
            }
            catch (IOException e) {
                Logger.messageError("Error, cannot read " + f.getString("fileObj"));
                throw new RuntimeException(e);
            }
        });
        AtomicReference<AbstractGenerator> generator = new AtomicReference<AbstractGenerator>();
        switch ((String)this.getWfFormat().getOrElse((Object)"json")) {
            case "md": 
            case "markdown": {
                generator.set(new MarkdownGenerator());
                break;
            }
            case "html": {
                generator.set(new HTMLGenerator());
                break;
            }
            case "pdf": {
                generator.set(new PDFGenerator());
                break;
            }
            default: {
                generator.set(new JSONGenerator());
            }
        }
        String dest = (String)this.getWfDest().getOrElse((Object)".");
        if (dest.startsWith(".")) {
            dest = System.getProperty("user.dir") + File.separator + dest;
        }
        Logger.messageInfo("Generating " + (String)this.getWfFormat().getOrElse((Object)"json") + " files into " + new File(dest).getCanonicalPath());
        List<JSONObject> output = ((AbstractGenerator)generator.get()).output(new File(dest), fileListToProcess);
        Logger.messageSusccess(output.size() + " scripts parsed");
    }

    private String wrapMacro(String macroWS) {
        return macroWS + "\n 'macro' STORE <% INFOMODE $macro EVAL %> EVAL 'macro' STORE ";
    }

    private List<File> getFiles(File root) throws IOException {
        try (Stream<Path> stream = Files.find(Paths.get(root.getPath(), new String[0]), Integer.MAX_VALUE, (filePath, fileAttr) -> fileAttr.isRegularFile() && filePath.toFile().getAbsolutePath().endsWith(".mc2"), new FileVisitOption[0]);){
            List<File> list = stream.map(Path::toFile).collect(Collectors.toList());
            return list;
        }
    }
}

