/*
 * Decompiled with CFR 0.152.
 */
package io.warp10.warpfleet;

import io.warp10.warpfleet.WarpFleetExtension;
import io.warp10.warpfleet.actions.GenerateDocumentation;
import io.warp10.warpfleet.actions.GetArtifactInfo;
import io.warp10.warpfleet.actions.GetArtifacts;
import io.warp10.warpfleet.actions.GetGroups;
import io.warp10.warpfleet.actions.GetVersions;
import io.warp10.warpfleet.actions.InitModule;
import io.warp10.warpfleet.actions.InstallArtifact;
import io.warp10.warpfleet.actions.Publish;
import io.warp10.warpfleet.actions.UnPublish;
import org.gradle.api.Plugin;
import org.gradle.api.Project;

public class WFPlugin
implements Plugin<Project> {
    public void apply(Project project) {
        WarpFleetExtension ext = (WarpFleetExtension)project.getExtensions().create("warpfleet", WarpFleetExtension.class, new Object[0]);
        project.getTasks().register("wfGetGroups", GetGroups.class);
        project.getTasks().register("wfGetArtifacts", GetArtifacts.class, t -> t.getWFGroup().set(ext.getGroup()));
        project.getTasks().register("wfGetVersions", GetVersions.class, t -> {
            t.getWFGroup().set(ext.getGroup());
            t.getWFArtifact().set(ext.getArtifact());
        });
        project.getTasks().register("wfGetArtifactInfo", GetArtifactInfo.class, t -> {
            t.getWFGroup().set(ext.getGroup());
            t.getWFArtifact().set(ext.getArtifact());
            t.getWFVersion().set(ext.getVers());
        });
        project.getTasks().register("wfInstall", InstallArtifact.class, t -> {
            t.getWfPackages().set(ext.getPackages());
            t.getWfRepoURL().set(ext.getRepoURL());
            t.getWfClassifier().set(ext.getClassifier());
            t.getWfVersion().set(ext.getVers());
            t.getWfArtifact().set(ext.getArtifact());
            t.getWfGroup().set(ext.getGroup());
            t.getWarp10Dir().set(ext.getWarp10Dir());
        });
        project.getTasks().register("wfDoc", GenerateDocumentation.class, t -> {
            t.getWfFormat().set(ext.getFormat());
            t.getWfMacroDir().set(ext.getMacroDir());
            t.getWfDest().set(ext.getDest());
            t.getWfUrl().set(ext.getUrl());
            t.getWfSource().set(ext.getSource());
        });
        project.getTasks().register("wfPublish", Publish.class, t -> {
            t.getWFRepoUrl().set(ext.getRepoUrl());
            t.getWfVersion().set(ext.getVers());
            t.getWFGpgKeyId().set(ext.getGpgKeyId());
            t.getWFGpgArg().set(ext.getGpgArg());
            t.getWFJson().set(ext.getWfJson());
        });
        project.getTasks().register("wfUnPublish", UnPublish.class, t -> {
            t.getWFRepoUrl().set(ext.getRepoUrl());
            t.getWFVersion().set(ext.getVers());
            t.getWFGpgKeyId().set(ext.getGpgKeyId());
            t.getWFGpgArg().set(ext.getGpgArg());
            t.getWFJson().set(ext.getWfJson());
            t.getWFForce().set(ext.getForce());
        });
        project.getTasks().register("wfInit", InitModule.class, t -> {
            t.getWfVersion().set(ext.getVers());
            t.getWfArtifact().set(ext.getArtifact());
            t.getWfGroup().set(ext.getGroup());
            t.getWfDest().set(ext.getDest());
            t.getWfType().set(ext.getType());
        });
    }
}

