/*
 * Decompiled with CFR 0.152.
 */
package io.warp10.warpfleet.actions;

import io.warp10.warpfleet.utils.Constants;
import io.warp10.warpfleet.utils.Helper;
import io.warp10.warpfleet.utils.Logger;
import io.warp10.warpfleet.utils.PackageInfo;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.CopyOption;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.Properties;
import java.util.function.BiConsumer;
import java.util.stream.Collectors;
import kong.unirest.Unirest;
import kong.unirest.json.JSONArray;
import kong.unirest.json.JSONObject;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.gradle.api.DefaultTask;
import org.gradle.api.provider.Property;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.Optional;
import org.gradle.api.tasks.TaskAction;
import org.gradle.api.tasks.options.Option;

public abstract class InstallArtifact
extends DefaultTask {
    @Input
    @Optional
    @Option(option="group", description="Artifact's group, ie: io.warp10")
    public abstract Property<String> getWfGroup();

    @Input
    @Optional
    @Option(option="artifact", description="Artifact's name, ie: warp10-plugin-mqtt")
    public abstract Property<String> getWfArtifact();

    @Input
    @Optional
    @Option(option="vers", description="Artifact's version, ie: 0.0.3")
    public abstract Property<String> getWfVersion();

    @Input
    @Option(option="dest", description="Warp 10 root installation directory, ie: /opt/warp10")
    public abstract Property<String> getWarp10Dir();

    @Input
    @Optional
    @Option(option="packages", description="Coma separated list of packages to install")
    public abstract Property<String> getWfPackages();

    @Input
    @Optional
    @Option(option="classifier", description="Artifact's classifier, ie: uberjar")
    public abstract Property<String> getWfClassifier();

    @Input
    @Optional
    @Option(option="repoURL", description="Artifact's maven like repo url")
    public abstract Property<String> getWfRepoURL();

    public InstallArtifact() {
        this.setDescription("Install Artifact");
        this.setGroup(Constants.GROUP);
    }

    @TaskAction
    public void installArtifact() throws IOException, InterruptedException {
        List<Object> packages = new ArrayList();
        try {
            String vers = (String)this.getWfVersion().getOrNull();
            if (!StringUtils.isBlank((CharSequence)((CharSequence)this.getWfPackages().getOrNull())) && !"unspecified".equals(this.getWfPackages().getOrNull())) {
                packages = Arrays.stream(((String)this.getWfPackages().get()).split(",")).map(p -> {
                    String version;
                    String[] parts = p.split(":");
                    if (parts.length < 2) {
                        Logger.messageError("Wrong syntax for :" + p);
                        throw new RuntimeException("Bad syntax");
                    }
                    PackageInfo packageInfo = new PackageInfo();
                    packageInfo.setGroup(parts[0]);
                    packageInfo.setName(parts[1]);
                    if (parts.length == 2) {
                        version = Helper.getLatest(parts[0], parts[1]).getJSONObject("latest").getString("version");
                        packageInfo.setVersion(version);
                    }
                    if (parts.length > 2) {
                        version = parts[2];
                        if (StringUtils.isBlank((CharSequence)version) || "latest".equals(version)) {
                            version = Helper.getLatest(parts[0], parts[1]).getJSONObject("latest").getString("version");
                        }
                        packageInfo.setVersion(version);
                    }
                    if (parts.length > 3 && !StringUtils.isBlank((CharSequence)parts[3])) {
                        packageInfo.setClassifier(parts[3]);
                    }
                    return packageInfo;
                }).collect(Collectors.toList());
            } else {
                if (StringUtils.isBlank((CharSequence)vers) || "unspecified".equals(vers) || "latest".equals(vers)) {
                    vers = Helper.getLatest((String)this.getWfGroup().get(), (String)this.getWfArtifact().get()).getJSONObject("latest").getString("version");
                }
                if (StringUtils.isBlank((CharSequence)((CharSequence)this.getWfGroup().getOrNull())) || "unspecified".equals(this.getWfGroup().getOrNull())) {
                    Logger.messageError("Artifact's group is mandatory");
                    return;
                }
                if (StringUtils.isBlank((CharSequence)((CharSequence)this.getWfArtifact().getOrNull())) || "unspecified".equals(this.getWfArtifact().getOrNull())) {
                    Logger.messageError("Artifact's name is mandatory");
                    return;
                }
                if (StringUtils.isBlank((CharSequence)((CharSequence)this.getWarp10Dir().getOrNull())) || "unspecified".equals(this.getWarp10Dir().getOrNull())) {
                    Logger.messageError("Warp 10 root directory is mandatory");
                    return;
                }
                String classifier = (String)this.getWfClassifier().getOrNull();
                if (StringUtils.isBlank((CharSequence)classifier) || "unspecified".equals(classifier)) {
                    classifier = null;
                }
                packages.add(new PackageInfo((String)this.getWfGroup().get(), (String)this.getWfArtifact().get(), vers, classifier));
            }
            for (PackageInfo packageInfo : packages) {
                File workDir;
                JSONArray dependencies;
                Logger.messageInfo("Retrieving " + packageInfo + " info");
                JSONObject info = Helper.getArtifactInfo(packageInfo);
                Logger.messageInfo("Installing " + packageInfo + " into: " + (String)this.getWarp10Dir().get());
                if (null != info.getJSONArray("macros")) {
                    for (Object m : info.getJSONArray("macros")) {
                        Helper.getMacro((String)this.getWfGroup().get(), (String)this.getWfArtifact().get(), vers, (JSONObject)m, (String)this.getWarp10Dir().get());
                    }
                }
                if (null == (dependencies = info.optJSONArray("dependencies"))) {
                    dependencies = new JSONArray();
                }
                if ((workDir = Helper.filePath(FileUtils.getTempDirectoryPath(), ".wf")).exists()) {
                    FileUtils.deleteDirectory((File)workDir);
                }
                FileUtils.forceMkdir((File)workDir);
                File depsDir = Helper.filePath(workDir.getAbsolutePath(), "deps");
                FileUtils.forceMkdir((File)depsDir);
                String jar = info.getString("jar");
                String fileName = packageInfo.getGroup() + "-" + packageInfo.getName() + "-" + packageInfo.getVersion() + ".jar";
                Logger.messageInfo("Retrieving: " + fileName);
                Unirest.get((String)jar).asFile(Helper.path(depsDir.getAbsolutePath(), fileName), new CopyOption[0]).ifFailure(Helper::processHTTPError).getBody();
                Logger.messageSusccess(fileName + " retrieved");
                Logger.messageInfo("Calculating dependencies");
                String repoURL = info.getString("repoUrl");
                if (!StringUtils.isBlank((CharSequence)((CharSequence)this.getWfRepoURL().getOrNull())) && !"unspecified".equals(this.getWfRepoURL().getOrNull())) {
                    repoURL = (String)this.getWfRepoURL().get();
                }
                StringBuilder gradle = new StringBuilder().append("plugins { id 'java' }\n").append("sourceCompatibility = '1.8'\n").append("targetCompatibility = '1.8'\n").append("repositories {\n").append(" maven { url '").append(repoURL).append("' }\n").append(" mavenCentral()\n").append("}\n").append("dependencies {\n");
                dependencies.forEach(d -> {
                    JSONObject dep = (JSONObject)d;
                    gradle.append(" implementation '").append(dep.getString("group")).append(":").append(dep.getString("artifact")).append(":").append(dep.getString("version"));
                    String classifier = dep.optString("classifier", "");
                    if (!"".equals(classifier)) {
                        gradle.append(":").append(classifier);
                    }
                    gradle.append("'\n");
                });
                gradle.append("}\n").append("task getDeps(type: Copy) {\n").append(" from sourceSets.main.runtimeClasspath\n").append(" into '").append(depsDir.getAbsolutePath()).append("'\n").append("}");
                FileUtils.write((File)Helper.filePath(workDir.getAbsolutePath(), "build.gradle"), (CharSequence)gradle.toString(), (Charset)StandardCharsets.UTF_8);
                FileUtils.write((File)Helper.filePath(workDir.getAbsolutePath(), "settings.gradle"), (CharSequence)"rootProject.name = 'newProjectName'", (Charset)StandardCharsets.UTF_8);
                Helper.execCmd("./gradlew getDeps -q -b " + Helper.path(workDir.getAbsolutePath(), "build.gradle"));
                Logger.messageInfo("Installing dependencies:");
                List jarList = Arrays.stream((Object[])Objects.requireNonNull(depsDir.listFiles())).filter(f -> f.getName().endsWith(".jar")).collect(Collectors.toList());
                for (File f2 : jarList) {
                    FileUtils.copyFile((File)f2, (File)Helper.filePath((String)this.getWarp10Dir().get(), "lib", f2.getName()));
                    Logger.messageSusccess("Dependency: " + f2.getName() + " successfully deployed");
                }
                Logger.messageInfo("Calculating properties");
                File propertyFile = Helper.filePath((String)this.getWarp10Dir().get(), "etc", "conf.d", "99-" + packageInfo.getGroup() + "-" + packageInfo.getName() + ".conf");
                Properties props = new Properties();
                if (propertyFile.exists()) {
                    Logger.messageWarning(propertyFile.getAbsolutePath() + " already exists, will backup it");
                    SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd_HH-mm-ss");
                    String backupName = "_" + dateFormat.format(new Date());
                    FileUtils.copyFile((File)propertyFile, (File)new File(propertyFile.getAbsolutePath() + backupName));
                }
                StringBuilder properties = new StringBuilder();
                properties.append("// -------------------------------------------------------------------------------------\n").append("// ").append(packageInfo).append('\n').append("// -------------------------------------------------------------------------------------\n\n");
                if (info.has("conf")) {
                    info.getJSONArray("conf").forEach(p -> {
                        if (((String)p).startsWith("//") || ((String)p).startsWith("#")) {
                            properties.append(p);
                        } else {
                            String[] currentProp = (String[])Arrays.stream(((String)p).split("=")).map(String::trim).toArray(String[]::new);
                            if (props.containsKey(currentProp[0])) {
                                Logger.messageWarning(currentProp[0] + " already exists, bypassing");
                            } else {
                                props.put(currentProp[0], currentProp.length > 1 ? currentProp[1] : "");
                            }
                        }
                    });
                    props.forEach((BiConsumer<? super Object, ? super Object>)((BiConsumer<Object, Object>)(k, v) -> properties.append(k).append("=").append(v).append('\n')));
                } else {
                    if ("plugin".equals(info.getString("type"))) {
                        Logger.messageWarning("No configuration found, do not forget to add 'warpscript.plugins.xxx = package.class'");
                    }
                    if ("ext".equals(info.getString("type"))) {
                        Logger.messageWarning("No configuration found, do not forget to add 'warpscript.extension.xxx = package.class'");
                    }
                }
                FileUtils.write((File)propertyFile, (CharSequence)properties.toString(), (Charset)StandardCharsets.UTF_8, (boolean)false);
                Logger.messageSusccess(packageInfo + " installed successfully.\nDo not forget to check the configuration file: " + propertyFile.getAbsolutePath());
                if (!workDir.exists()) continue;
                FileUtils.deleteDirectory((File)workDir);
            }
        }
        catch (Throwable e) {
            Logger.messageError(e.getMessage());
            throw e;
        }
    }
}

