/*
 * Decompiled with CFR 0.152.
 */
package io.warp10.warpfleet.actions;

import io.warp10.warpfleet.utils.Constants;
import io.warp10.warpfleet.utils.Helper;
import java.util.ArrayList;
import kong.unirest.json.JSONObject;
import org.apache.commons.lang3.StringUtils;
import org.gradle.api.DefaultTask;
import org.gradle.api.provider.Property;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.Optional;
import org.gradle.api.tasks.TaskAction;
import org.gradle.api.tasks.options.Option;

public abstract class GetArtifacts
extends DefaultTask {
    @Input
    @Optional
    @Option(option="group", description="Artifact's group, ie: io.warp10")
    public abstract Property<String> getWFGroup();

    public GetArtifacts() {
        this.setDescription("Get list of available artifacts");
        this.setGroup(Constants.GROUP);
    }

    @TaskAction
    public void getArtifacts() {
        ArrayList<String> groups = new ArrayList<String>();
        if (StringUtils.isBlank((CharSequence)((CharSequence)this.getWFGroup().getOrNull()))) {
            Helper.getGroups().forEach(g -> groups.add(((JSONObject)g).getString("name")));
        } else {
            groups.add(((String)this.getWFGroup().get()).trim());
        }
        groups.forEach(g -> Helper.getArtifacts(g).forEach(item -> {
            JSONObject repo = (JSONObject)item;
            JSONObject latest = repo.optJSONObject("latest");
            if (null != latest) {
                System.out.printf("- %s:%s:%s (%s)\n", latest.getString("group"), latest.getString("artifact"), latest.getString("version"), latest.getString("description"));
            }
        }));
    }
}

