/*
 * Decompiled with CFR 0.152.
 */
package io.warp10.warpfleet.actions;

import io.warp10.warpfleet.utils.Constants;
import io.warp10.warpfleet.utils.Helper;
import kong.unirest.json.JSONObject;
import org.gradle.api.DefaultTask;
import org.gradle.api.provider.Property;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.Optional;
import org.gradle.api.tasks.TaskAction;
import org.gradle.api.tasks.options.Option;

public abstract class GetArtifactInfo
extends DefaultTask {
    @Input
    @Option(option="group", description="Artifact's group, ie: io.warp10")
    public abstract Property<String> getWFGroup();

    @Input
    @Option(option="artifact", description="Artifact's name, ie: warp10-plugin-mqtt")
    public abstract Property<String> getWFArtifact();

    @Input
    @Optional
    @Option(option="vers", description="Artifact's version, ie: 0.0.3")
    public abstract Property<String> getWFVersion();

    public GetArtifactInfo() {
        this.setDescription("Get Artifact info");
        this.setGroup(Constants.GROUP);
    }

    @TaskAction
    public void getArtifactInfo() {
        String version = (String)this.getWFVersion().getOrNull();
        if (null == version || "unspecified".equals(version) || "latest".equals(version)) {
            version = Helper.getLatest((String)this.getWFGroup().get(), (String)this.getWFArtifact().get()).getJSONObject("latest").getString("version");
        }
        JSONObject info = Helper.getArtifactInfo((String)this.getWFGroup().get(), (String)this.getWFArtifact().get(), version);
        System.out.printf("- %s:%s:%s (%s)\n", info.getString("group"), info.getString("artifact"), info.getString("version"), info.getString("description"));
    }
}

