/*
 * Decompiled with CFR 0.152.
 */
package io.warp10.plugins.mqtt;

import io.warp10.plugins.mqtt.MQTTConsumer;
import io.warp10.plugins.mqtt.MQTTWarpScriptExtension;
import io.warp10.script.WarpScriptLib;
import io.warp10.warp.sdk.AbstractWarp10Plugin;
import io.warp10.warp.sdk.WarpScriptExtension;
import java.io.File;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.locks.LockSupport;

public class MQTTWarp10Plugin
extends AbstractWarp10Plugin
implements Runnable {
    private static final String CONF_MQTT_DIR = "mqtt.dir";
    private static final String CONF_MQTT_PERIOD = "mqtt.period";
    private static final long DEFAULT_PERIOD = 60000L;
    private String dir;
    private long period;
    private Map<String, MQTTConsumer> consumers = new HashMap<String, MQTTConsumer>();
    private boolean done = false;

    public MQTTWarp10Plugin() {
        MQTTWarpScriptExtension ext = new MQTTWarpScriptExtension();
        WarpScriptLib.register((WarpScriptExtension)ext);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        while (true) {
            DirectoryStream<Path> pathes = null;
            try {
                if (this.done) {
                    return;
                }
                pathes = Files.newDirectoryStream(new File(this.dir).toPath(), "*.mc2");
                Iterator<Path> iter = pathes.iterator();
                HashSet<String> specs = new HashSet<String>();
                while (iter.hasNext()) {
                    Path p = iter.next();
                    String filename = p.getFileName().toString();
                    boolean load = false;
                    if (this.consumers.containsKey(filename)) {
                        if ((long)this.consumers.get(filename).getWarpScript().length() != p.toFile().length()) {
                            load = true;
                        }
                    } else {
                        load = true;
                    }
                    if (load) {
                        this.load(filename);
                    }
                    specs.add(filename);
                }
                pathes.close();
                HashSet<String> removed = new HashSet<String>(this.consumers.keySet());
                removed.removeAll(specs);
                for (String spec : removed) {
                    try {
                        this.consumers.remove(spec).end();
                    }
                    catch (Exception exception) {}
                }
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
            finally {
                if (null != pathes) {
                    try {
                        pathes.close();
                    }
                    catch (Exception exception) {}
                }
            }
            LockSupport.parkNanos(this.period * 1000000L);
        }
    }

    private boolean load(String filename) {
        MQTTConsumer consumer = this.consumers.get(filename);
        if (null != consumer) {
            consumer.end();
        }
        try {
            consumer = new MQTTConsumer(new File(this.dir, filename).toPath());
        }
        catch (Exception e) {
            return false;
        }
        this.consumers.put(filename, consumer);
        return true;
    }

    public void init(Properties properties) {
        this.dir = properties.getProperty(CONF_MQTT_DIR);
        if (null == this.dir) {
            throw new RuntimeException("Missing 'mqtt.dir' configuration.");
        }
        this.period = Long.parseLong(properties.getProperty(CONF_MQTT_PERIOD, Long.toString(60000L)));
        Runtime.getRuntime().addShutdownHook(new Thread(){

            @Override
            public void run() {
                MQTTWarp10Plugin.this.done = true;
                System.out.println("MQTT Plugin shutting down all consumers.");
                this.interrupt();
                for (MQTTConsumer consumer : MQTTWarp10Plugin.this.consumers.values()) {
                    try {
                        consumer.end();
                    }
                    catch (Exception exception) {}
                }
            }
        });
        Thread t = new Thread(this);
        t.setDaemon(true);
        t.setName("[Warp 10 MQTT Plugin " + this.dir + "]");
        t.start();
    }
}

