/*
 * Decompiled with CFR 0.152.
 */
package io.warp10.script.ext.jdbc;

import io.warp10.continuum.gts.GTSHelper;
import io.warp10.continuum.gts.GeoTimeSerie;
import io.warp10.continuum.store.Constants;
import io.warp10.continuum.store.thrift.data.Metadata;
import io.warp10.script.NamedWarpScriptFunction;
import io.warp10.script.WarpScriptException;
import io.warp10.script.WarpScriptStack;
import io.warp10.script.WarpScriptStackFunction;
import java.sql.Connection;
import java.sql.Date;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.TimeZone;

public class SQLEXEC
extends NamedWarpScriptFunction
implements WarpScriptStackFunction {
    private final Calendar gmtCalendar = Calendar.getInstance(TimeZone.getTimeZone("GMT"));

    public SQLEXEC(String name) {
        super(name);
    }

    public Object apply(WarpScriptStack stack) throws WarpScriptException {
        block49: {
            Object top = stack.pop();
            if (null != top && !(top instanceof List)) {
                throw new WarpScriptException(this.getName() + " expected a list of value fields or NULL.");
            }
            List valueNames = (List)top;
            top = stack.pop();
            if (!(top instanceof String)) {
                throw new WarpScriptException(this.getName() + " expects a SQL statement.");
            }
            String sql = (String)top;
            top = stack.pop();
            List prepValues = null;
            if (top instanceof List) {
                prepValues = (List)top;
                top = stack.pop();
            }
            if (!(top instanceof Map)) {
                throw new WarpScriptException(this.getName() + " expected a property map before the SQL statement.");
            }
            Properties props = new Properties();
            for (Map.Entry entry : ((Map)top).entrySet()) {
                if (!(entry.getKey() instanceof String) || !(entry.getValue() instanceof String)) {
                    throw new WarpScriptException(this.getName() + " expects the properties MAP to have STRING keys and STRING values.");
                }
                props.setProperty((String)entry.getKey(), (String)entry.getValue());
            }
            String url = stack.pop().toString();
            Connection conn = null;
            Statement stmt = null;
            ResultSet rs = null;
            try {
                conn = DriverManager.getConnection(url, props);
                if (null != prepValues) {
                    stmt = conn.prepareStatement(sql);
                    PreparedStatement pstmt = (PreparedStatement)stmt;
                    for (Object val : prepValues) {
                        if (!(val instanceof List)) {
                            throw new WarpScriptException(this.getName() + " expects values to be inserted to be LISTs.");
                        }
                        List tuple = (List)val;
                        for (int i = 0; i < tuple.size(); ++i) {
                            pstmt.setObject(i + 1, tuple.get(i));
                        }
                        pstmt.addBatch();
                    }
                    long[] counts = pstmt.executeLargeBatch();
                    ArrayList<Long> countsList = new ArrayList<Long>(counts.length);
                    for (Object c : (List)counts) {
                        countsList.add((long)c);
                    }
                    stack.push(countsList);
                    break block49;
                }
                stmt = conn.createStatement();
                boolean isResultSet = stmt.execute(sql);
                long updateCount = stmt.getLargeUpdateCount();
                if (isResultSet) {
                    rs = stmt.getResultSet();
                    ResultSetMetaData rsmd = rs.getMetaData();
                    int n = rsmd.getColumnCount();
                    if (null == valueNames) {
                        int[] types = new int[n + 1];
                        for (int i = 1; i <= n; ++i) {
                            types[i] = rsmd.getColumnType(i);
                        }
                        ArrayList result = new ArrayList();
                        while (rs.next()) {
                            ArrayList<Object> row = new ArrayList<Object>(n);
                            for (int i = 1; i <= n; ++i) {
                                try {
                                    Object o = SQLEXEC.sqlToWarpScript(types[i], rs, i, this.gmtCalendar);
                                    row.add(o);
                                    continue;
                                }
                                catch (WarpScriptException | SQLException e) {
                                    throw new WarpScriptException(this.getName() + " couldn't convert the data.", e);
                                }
                            }
                            result.add(row);
                        }
                        stack.push(result);
                        break block49;
                    }
                    HashMap<String, Integer> colidx = new HashMap<String, Integer>();
                    HashMap<String, Integer> labelidx = new HashMap<String, Integer>();
                    int tsidx = -1;
                    for (int i = 1; i <= n; ++i) {
                        if (valueNames.get(0).equals(rsmd.getColumnLabel(i))) {
                            tsidx = i;
                            continue;
                        }
                        if (valueNames.contains(rsmd.getColumnLabel(i))) {
                            colidx.put(rsmd.getColumnLabel(i), i);
                            continue;
                        }
                        labelidx.put(rsmd.getColumnLabel(i), i);
                    }
                    if (-1 == tsidx) {
                        throw new WarpScriptException(this.getName() + " did not find timestamp column '" + valueNames.get(0) + "'.");
                    }
                    int tsType = rsmd.getColumnType(tsidx);
                    HashMap<Metadata, GeoTimeSerie> mgts = new HashMap<Metadata, GeoTimeSerie>();
                    HashMap labels = new HashMap();
                    while (rs.next()) {
                        Object o;
                        labels.clear();
                        for (Map.Entry entry : labelidx.entrySet()) {
                            String val = rs.getString((Integer)entry.getValue());
                            if (rs.wasNull()) continue;
                            labels.put(entry.getKey(), val);
                        }
                        try {
                            o = SQLEXEC.sqlToWarpScript(tsType, rs, tsidx, this.gmtCalendar);
                        }
                        catch (WarpScriptException | SQLException e) {
                            throw new WarpScriptException(this.getName() + " is given an invalid column type for timestamp.", e);
                        }
                        if (!(o instanceof Number)) {
                            throw new WarpScriptException(this.getName() + " is given an invalid column type for timestamp.");
                        }
                        long ts = ((Number)o).longValue();
                        if (rs.wasNull()) continue;
                        for (Map.Entry entry : colidx.entrySet()) {
                            Object val = rs.getObject((Integer)entry.getValue());
                            if (rs.wasNull()) continue;
                            Metadata meta = new Metadata();
                            meta.setLabels(new HashMap(labels));
                            meta.setName((String)entry.getKey());
                            GeoTimeSerie gts = (GeoTimeSerie)mgts.get(meta);
                            if (null == gts) {
                                gts = new GeoTimeSerie();
                                gts.setMetadata(meta);
                                mgts.put(meta, gts);
                            }
                            GTSHelper.setValue((GeoTimeSerie)gts, (long)ts, (Object)val);
                        }
                    }
                    ArrayList lgts = new ArrayList();
                    lgts.addAll(mgts.values());
                    stack.push(lgts);
                    break block49;
                }
                ArrayList<Long> count = new ArrayList<Long>(1);
                count.add(updateCount);
                stack.push(count);
            }
            catch (SQLException sqle) {
                throw new WarpScriptException(this.getName() + " caught a SQL Exception.", (Throwable)sqle);
            }
            finally {
                if (null != rs) {
                    try {
                        rs.close();
                    }
                    catch (SQLException sQLException) {}
                }
                if (null != stmt) {
                    try {
                        stmt.close();
                    }
                    catch (SQLException sQLException) {}
                }
                if (null != conn) {
                    try {
                        conn.close();
                    }
                    catch (SQLException sqle) {
                        throw new WarpScriptException(this.getName() + " caught a SQL Exception while closing the connection.", (Throwable)sqle);
                    }
                }
            }
        }
        return stack;
    }

    private static Object sqlToWarpScript(int type, ResultSet rs, int colIndex, Calendar gmtCalendar) throws WarpScriptException, SQLException {
        Object o;
        if (null == rs.getObject(colIndex)) {
            return null;
        }
        switch (type) {
            case -7: 
            case 16: {
                o = rs.getBoolean(colIndex);
                break;
            }
            case -6: 
            case 4: 
            case 5: {
                o = rs.getLong(colIndex);
                break;
            }
            case -5: {
                o = rs.getBigDecimal(colIndex);
                break;
            }
            case 2: 
            case 3: 
            case 6: 
            case 7: 
            case 8: {
                o = rs.getDouble(colIndex);
                break;
            }
            case -16: 
            case -15: 
            case -9: 
            case -1: 
            case 1: 
            case 12: 
            case 2005: {
                o = rs.getString(colIndex);
                break;
            }
            case 93: {
                Timestamp timestamp = rs.getTimestamp(colIndex, gmtCalendar);
                o = timestamp.getTime() / 1000L * Constants.TIME_UNITS_PER_S + (long)timestamp.getNanos() / Constants.NS_PER_TIME_UNIT;
                break;
            }
            case 2014: {
                Timestamp timestampTZ = rs.getTimestamp(colIndex);
                o = timestampTZ.getTime() / 1000L * Constants.TIME_UNITS_PER_S + (long)timestampTZ.getNanos() / Constants.NS_PER_TIME_UNIT;
                break;
            }
            case 91: {
                Date date = rs.getDate(colIndex, gmtCalendar);
                o = date.getTime() / 1000L * Constants.TIME_UNITS_PER_S;
                break;
            }
            case 92: {
                Time time = rs.getTime(colIndex, gmtCalendar);
                o = time.getTime() / 1000L * Constants.TIME_UNITS_PER_S;
                break;
            }
            case 2013: {
                Time timeTZ = rs.getTime(colIndex);
                o = timeTZ.getTime() / 1000L * Constants.TIME_UNITS_PER_S;
                break;
            }
            case -4: 
            case -3: 
            case -2: 
            case 2004: {
                o = rs.getBytes(colIndex);
                break;
            }
            case 0: {
                o = null;
                break;
            }
            default: {
                throw new WarpScriptException("Got unhandled type " + type + ".");
            }
        }
        return o;
    }
}

