/*
 * Decompiled with CFR 0.152.
 */
package io.warp10.ext.git;

import io.warp10.ext.git.GitWarpScriptExtension;
import io.warp10.script.NamedWarpScriptFunction;
import io.warp10.script.WarpScriptException;
import io.warp10.script.WarpScriptStack;
import io.warp10.script.WarpScriptStackFunction;
import io.warp10.warp.sdk.Capabilities;
import java.io.File;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.api.LogCommand;
import org.eclipse.jgit.api.TagCommand;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.PersonIdent;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.revwalk.RevObject;
import org.eclipse.jgit.revwalk.RevWalk;

public class GITTAG
extends NamedWarpScriptFunction
implements WarpScriptStackFunction {
    public GITTAG(String name) {
        super(name);
    }

    public Object apply(WarpScriptStack stack) throws WarpScriptException {
        Object top = stack.pop();
        if (!(top instanceof Map)) {
            throw new WarpScriptException(this.getName() + " expects a parameter MAP.");
        }
        Map params = (Map)top;
        if (!(params.get("message") instanceof String)) {
            throw new WarpScriptException(this.getName() + " expects a commit message under key '" + "message" + "'.");
        }
        String message = (String)params.get("message");
        if (!(params.get("tag") instanceof String)) {
            throw new WarpScriptException(this.getName() + " unset tag under key '" + "tag" + "'.");
        }
        String tag = (String)params.get("tag");
        boolean force = Boolean.TRUE.equals(params.get("force"));
        String rev = "HEAD";
        if (params.get("rev") instanceof String) {
            rev = (String)params.get("rev");
        }
        if (!(params.get("repo") instanceof String)) {
            throw new WarpScriptException(this.getName() + " unset repository under key '" + "repo" + "'.");
        }
        String repo = (String)params.get("repo");
        if (null == GitWarpScriptExtension.getRoot()) {
            throw new WarpScriptException(this.getName() + " Git root was not configured.");
        }
        Map capabilities = Capabilities.get((WarpScriptStack)stack, (List)null);
        if (!repo.equals(capabilities.get("git.repo"))) {
            throw new WarpScriptException(this.getName() + " missing or invalid '" + "git.repo" + "' capability.");
        }
        if (null != capabilities.get("git.ro")) {
            throw new WarpScriptException(this.getName() + " no right to modify repository '" + repo + "'.");
        }
        String path = null;
        if (null != capabilities.get("git.subdir")) {
            path = (String)capabilities.get("git.subdir");
        }
        Git git = null;
        try {
            git = Git.open((File)new File(GitWarpScriptExtension.getRoot(), repo));
            RevCommit revcommit = null;
            if (null != path) {
                LogCommand log = git.log();
                ObjectId oid = git.getRepository().resolve(rev);
                log.add((AnyObjectId)oid);
                log.addPath(path);
                Iterator iterator = log.call().iterator();
                if (iterator.hasNext()) {
                    RevCommit rc;
                    revcommit = rc = (RevCommit)iterator.next();
                }
                if (null == revcommit) {
                    throw new WarpScriptException(this.getName() + " invalid revision '" + rev + "', be more specific via key '" + "rev" + "'.");
                }
            } else {
                RevWalk rwalk = new RevWalk(git.getRepository());
                revcommit = rwalk.parseCommit((AnyObjectId)git.getRepository().resolve(rev));
            }
            TagCommand tc = git.tag();
            tc.setForceUpdate(force);
            tc.setAnnotated(true);
            tc.setName(tag);
            tc.setMessage(message);
            tc.setObjectId((RevObject)revcommit);
            PersonIdent person = new PersonIdent(capabilities.getOrDefault("git.name", "warp10-ext-git"), capabilities.getOrDefault("git.email", "contact@senx.io"));
            tc.setTagger(person);
            stack.push((Object)tc.call().getName());
        }
        catch (Exception e) {
            throw new WarpScriptException(this.getName() + " error adding tag '" + tag + "' to repository  '" + repo + "'.");
        }
        finally {
            if (null != git) {
                git.close();
            }
        }
        return stack;
    }
}

